% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_rubins.R
\name{combine_rubins}
\alias{combine_rubins}
\title{combine_rubins}
\usage{
combine_rubins(
  DGE,
  model_results,
  predictor,
  covariate = NULL,
  robust = FALSE,
  winsor.tail.p = c(0.05, 0.1)
)
}
\arguments{
\item{DGE}{A DGEList object.}

\item{model_results}{Output from limmavoom_imputed_datalist.}

\item{predictor}{Independent variable of interest, in the form of a linear model contrast. Must be a variable in voom_formula.}

\item{covariate}{Arguments passed to limma::squeezeVar. If non-NULL, var.prior will depend on this numeric covariate. Otherwise, var.prior is constant.}

\item{robust}{Arguments passed to limma::squeezeVar. Llogical, should the estimation of df.prior and var.prior be robustified against outlier sample variances?}

\item{winsor.tail.p}{Arguments passed to limma::squeezeVar. Numeric vector of length 1 or 2, giving left and right tail proportions of x to Winsorize. Used only when robust=TRUE.}
}
\value{
Dataframe with one row per gene containing coefficients standard errors, degrees of freedom, t-statistics, P-Values, and adjusted P-values from the limma-voom pipeline.
\item{coef_combined}{combined logFCs across the multiple imputed datasets using Rubin's rules}
\item{SE_P}{pooled standard error across the multiple imputed datasets using Rubin's rules}
\item{SE_P_bayes}{pooled standard error across the multiple imputed datasets using Rubin's rules squeezed to global mean variance trend curve with limma-voom Bayesian procedure}
\item{df}{limma-voom residual degrees of freedom adjusted for Rubin's rules}
\item{df_bayes}{limma-voom residual degrees of freedom adjusted for Rubin's rules and Bayesian procedure}
\item{rubins_t}{t-statistic = coef_combined divided by SE_p}
\item{rubins_t_bayes}{t-statistic = coef_combined divided by SE_p_bayes}
\item{combined_p}{p-value from two-sided t-distribution alpha = 0.05 using rubins_t}
\item{combined_p_bayes}{p-value from two-sided t-distribution alpha = 0.05 using rubins_t_bayes}
\item{combined_p_adj}{false discovery rate (FDR) adjusted combined_p}
\item{combined_p_adj_bayes}{false discovery rate (FDR) adjusted combined_p_bayes}
}
\description{
Combines results from each imputed dataset using Rubin's rules.
}
\examples{
data(example_data)
data(example_DGE)
intervals <- get_gene_bin_intervals(example_DGE, example_data, n = 10)
gene_bin_impute <- impute_by_gene_bin(example_data,
    intervals,
    example_DGE,
    m = 2
)
coef_se <- limmavoom_imputed_data_list(
    gene_intervals = intervals,
    DGE = example_DGE,
    imputed_data_list = gene_bin_impute,
    m = 2,
    voom_formula = "~x + y + z + a + b"
)

final_res <- combine_rubins(
    DGE = example_DGE,
    model_results = coef_se,
    predictor = "x"
)
}
