% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAsense.R
\name{getSwitch}
\alias{getSwitch}
\title{Detect switching genes}
\usage{
getSwitch(dataset = mydata, experimentStepDetection = "WT",
  pValueSwitch = 0.05, cores = 1, mytimes = times)
}
\arguments{
\item{dataset}{Object of class SummarizedExperiment, output of \link{SummarizedExperiment}, as assays use a numeric matrix with your RNAseq count data, rows correspond to different genes, columns correspond to different experiments, as rowData provide a \link{DataFrame} with columns name (geneID) and genename (the gene names), as colData provide a \link{DataFrame} with columns condition, time and replicate}

\item{experimentStepDetection}{Character, Name of condition for which switch detection is performed}

\item{pValueSwitch}{Numeric, A threshold for counting cells as being invaded or not. When cells move towards negative z-direction, threshold should be negative.}

\item{cores}{Numeric, Number of cores for parallelization, default 1 for no parallelization}

\item{mytimes}{Numeric vector, Time points of the time-resolved RNA-seq data}
}
\value{
Data.frame containing gene names and results of switch detection, information about switch time point and direction
}
\description{
For each gene, time-resolved RNA-seq measurements are analyzed for occurence of switches (up or down)
}
\examples{
data(MZsox)
mydata <- MZsox[seq(1,nrow(MZsox), by=10),]
resultSwitch <- getSwitch(dataset = mydata,
experimentStepDetection = "WT",
cores = 1,
mytimes = c(2.5,3,3.5,4,4.5,5,5.5,6))
}
\author{
Marcus Rosenblatt, \email{marcus.rosenblatt@fdm.uni-freiburg.de}
}
