% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modifier-AlkAnilineSeq-class.R
\docType{class}
\name{ModAlkAnilineSeq}
\alias{ModAlkAnilineSeq}
\alias{AlkAnilineSeq}
\alias{ModSetAlkAnilineSeq}
\alias{ModAlkAnilineSeq-class}
\alias{ModSetAlkAnilineSeq-class}
\title{ModAlkAnilineSeq class to analyze AlkAnilineSeq data}
\usage{
ModAlkAnilineSeq(x, annotation = NA, sequences = NA, seqinfo = NA, ...)

ModSetAlkAnilineSeq(x, annotation = NA, sequences = NA, seqinfo = NA, ...)
}
\arguments{
\item{x}{the input which can be of the different types depending on whether
a \code{ModRiboMethSeq} or a \code{ModSetRiboMethSeq} object is to be 
constructed. For more information have a look at the documentation of
the \code{\link[RNAmodR:Modifier-class]{Modifier}} and 
\code{\link[RNAmodR:ModifierSet-class]{ModifierSet}} classes.}

\item{annotation}{annotation data, which must match the information contained
in the BAM files. This is parameter is only required if \code{x} if not a 
\code{Modifier} object.}

\item{sequences}{sequences matching the target sequences the reads were 
mapped onto. This must match the information contained in the BAM files. This
is parameter is only required if \code{x} if not a \code{Modifier} object.}

\item{seqinfo}{An optional \code{\link[Seqinfo:Seqinfo-class]{Seqinfo}} 
argument or character vector, which can be coerced to one, to subset the 
sequences to be analyzed on a per chromosome basis.}

\item{...}{Optional arguments overwriting default values, which are
\itemize{
\item minLength: The minimal read length to be used for the analysis 
(default: \code{minLength = 9L}).
\item minSignal: The minimal signal at the position as integer value 
(default: \code{minSignal = 10L}). If the reaction is very specific a lower
value may need to be used
\item minScoreNC: minimum for score (normalized cleavage) to identify m7G,
m3C and D positions de novo (default: \code{minScoreNC = 50L})
\item minScoreSR: minimum for score (stop ration) to identify m7G, m3C and D
positions de novo (default: \code{minScoreSR = 0.5})
\item minScoreBaseScore: minimum score for base calling (0.0-1.0)  
(default: \code{minScoreSR = 0.9})
\item scoreOperator: how the minimal score should be used as logical 
operator. "&" requires all minimal values to be exceeded, whereas "|" detects
positions, if at least one minimal values is exceeded (default: 
\code{scoreOperator = "&"}).
\item other arguments which are passed on to 
\code{\link[RNAmodR:EndSequenceData-class]{End5SequenceData}}
}}
}
\value{
a \code{ModAlkAnilineSeq} or \code{ModSetAlkAnilineSeq} object
}
\description{
7-methyl guanosine (m7G), 3-methyl cytidine (m3C) and Dihydrouridine (D) 
are commonly found in rRNA and tRNA and can be detected classically by
primer extension analysis. However, since the modifications do not interfere
with Watson-Crick base pairing, a specific chemical treatment is employed
to cause strand breaks specifically at the modified positions.

This classical protocol was converted to a high throughput sequencing 
method call AlkAnilineSeq and allows modified position be detected by an
accumulation of 5'-ends at the N+1 position. Since the identify of the 
unmodified nucleotide is different for the three modified nucleotides, they
modification can be detected at the same time from the same samples.

\code{dataType} is \code{c("NormEnd3SequenceData","PileupSequenceData")}:

The \code{ModAlkAnilineSeq} class uses the  
\code{\link[RNAmodR:NormEndSequenceData-class]{NormEnd5SequenceData}}
class to store and aggregate data along the transcripts. This includes 
normalized values against the whole transcript (normalzed cleavage) and 
normalized values against the overlapping reads (stop ratio), which are used
to score for modified positions.

In addition the 
\code{\link[RNAmodR:PileupSequenceData-class]{PileupSequenceData}} class is
used as well, to check, whether the base is can be called according to the
expected sequence identity.

Only samples named \code{treated} are used for this analysis. Normalization 
to untreated samples is currently not used.
}
\examples{
library(RNAmodR.Data)
library(rtracklayer)
annotation <- GFF3File(RNAmodR.Data.example.AAS.gff3())
sequences <- RNAmodR.Data.example.AAS.fasta()
files <- list("wt" = c(treated = RNAmodR.Data.example.wt.1()),
              "Bud23del" = c(treated = RNAmodR.Data.example.bud23.1()),
              "Trm8del" = c(treated = RNAmodR.Data.example.trm8.1()))
# Creating a Modifier object of type ModRiboMethSeq
maas <- ModAlkAnilineSeq(files[[1]], annotation = annotation,
                         sequences = sequences)
# Creating a ModifierSet object of type ModSetRiboMethSeq
msaas <- ModSetAlkAnilineSeq(files, annotation = annotation,
                             sequences = sequences)
}
\references{
- Marchand V, Ayadi L, __Ernst FGM__, Hertler J, Bourguignon-Igel V,
Galvanin A, Kotter A, Helm M, __Lafontaine DLJ__, Motorin Y (2018): 
"AlkAniline-Seq: Profiling of m7 G and m3 C RNA Modifications at Single 
Nucleotide Resolution." Angewandte Chemie (International ed. in English) 57 
(51), P. 16785–16790. DOI: 
\href{https://doi.org/10.1002/anie.201810946}{10.1002/anie.201810946}.
}
\author{
Felix G.M. Ernst [aut]
}
