% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Example_models.R
\docType{data}
\name{models}
\alias{models}
\title{Example double exponential decay modeling results}
\format{
a list of data frames, each with 240 rows (1/model) with 22 columns and 240 rows.
 \describe{
    \item{geneID}{gene identifier}
    \item{mod}{model names as factors}
    \item{alpha_XXX}{decay rate estimate of genotype XXX, in per time (min^-1)}
    \item{beta_XXX}{decay of decay rate estimate of genotype XXX, in per time (min^-1)}
    \item{sigma2}{variance estimate}
    \item{logLik}{maxium log likelihood}
    \item{nPar}{number of parameters in the given model}
    \item{nStarts}{number of parameter starting value sets (of 50) that converged on a maximum likelihood peak}
    \item{J}{number of parameter starting value sets that converged on the highest - within 1e-4 - maximum likelihood of all parameter starting value sets}
    \item{range.LL}{range of maximum likelihoods values reached by algorithm convergence from all parameter starting value sets}
    \item{nUnique.LL}{number of unique maximum likelihoods values reached by algorithm convergence from all parameter starting value sets}
    \item{C.alpha}{sum of all coefficients of variation for each column of alpha estimates}
    \item{C.beta}{sum of all coefficients of variation for each column of beta estimates}
    \item{C.tot}{C.alpha+C.beta}
    \item{AICc}{calculated from the single highest maximum likelihood of all parameter starting value sets}
    \item{AICc_est}{calculated from the log likelihood value computed by using the mean of each parameter from all optimizations that converged on the highest maximum likelihood of all starting parameter value sets}
    }
}
\source{
Sorenson et al. (2017) Submitted; \url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE86361}
}
\usage{
models
}
\description{
Example results from maximum likelihood modeling of double exponential RNA decay of 118 genes.
}
\keyword{datasets}
