% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay_plot.R
\name{decay_plot}
\alias{decay_plot}
\title{decay_plot() function}
\usage{
decay_plot(
  geneID,
  xlim = c(0, 500),
  ylim = c(0, 1.25),
  xticks = NA,
  yticks = 0:5/4,
  alphaSZ = 8,
  what = c("Desc", "models", "reps", "meanSE", "alphas&betas"),
  DATA,
  treatments = NA,
  colors = NA,
  mod.results = NA,
  gdesc = NA,
  desc.width = 55
)
}
\arguments{
\item{geneID}{single gene ID from data set (e.g. "AT1G00100") for which to plot data/model}

\item{xlim, ylim}{vector of length 2 defineing the limits of the plot (zooms in on data)}

\item{xticks, yticks}{vectors specifyng tick marks for the x and y axes}

\item{alphaSZ}{text size of alpha and beta parameter labels if plotted}

\item{what}{character vector specifying what to plot; any or all (default) of "Desc","models","reps","meanSE","alphas&betas"
"Desc"         - plots gene descriptions behind data
"models"       - plots the selected fit model
"reps"         - plots individual replicate data as distinct shapes
"meanSE        - plots the replicate means and standard errors
"alphas&betas" - plots the values of the alphas and betas for each model below the model at the greatest x position}

\item{DATA}{(required) normalized abundance decay data with column names: "geneID", "treatment","t.decay", "rep","value"}

\item{treatments}{what treatments/genotypes to plot from the supplied data}

\item{colors}{vector of R recognized colors (e.g. "red","darkblue")}

\item{mod.results}{(optional; required for plotting models) data.frame of the model results as output from the modeling (e.g. "alphas+betas+mods+grps+patterns+relABs.txt")}

\item{gdesc}{(optional; required for plotting gene descriptions) gene descriptions (geneID-named vector of gene descriptions geneID must match those of data)}

\item{desc.width}{width of gene descriptions (in number of characters) before word wrap}
}
\value{
returns a ggplot to be used with print; could also be modified using the syntax of ggplot2 e.g.'+geom_XXXX(...)'
}
\description{
Plots RNA decay data and/or decay models using the ggplot2 package.
}
\examples{
p<-decay_plot("Gene_BooFu",
          mod.results = data.frame(alpha_WT = 0.0830195, beta_WT = 0.04998945,
                                   model = 1, alpha_grp = 1, beta_grp = 1, alpha_subgroup = 1.1,
                                   row.names = "Gene_BooFu"),
          what = c("meanSE","alphas&betas","models"),
          treatments = "WT",
          colors = "black",
          DATA = data.frame(geneID=rep("Gene_BooFu",15),
                            treatment=rep("WT",15),
                            t.decay=rep(c(0,7.5,15,30,60),3),
                            rep=paste0("rep",c(rep(1,5),rep(2,5),rep(3,5))),
                            value= c(0.9173587, 0.4798672, 0.3327807, 0.1990708, 0.1656554,
                                     0.9407511, 0.7062988, 0.3450886, 0.3176824, 0.2749946,
                                     1.1026497, 0.6156978, 0.4563346, 0.2865779, 0.1680075)),
          xlim = c(0, 65),
          alphaSZ = 10)
print(p)

}
