% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msmsRawExtensions.r
\name{findMsMsHR.ticms2}
\alias{findMsMsHR.ticms2}
\alias{findMsMsHR.ticMS2}
\title{Extract an MS/MS spectrum from MS2 TIC}
\usage{
findMsMsHR.ticms2(
  msRaw,
  mz,
  limit.coarse,
  limit.fine,
  rtLimits = NA,
  maxCount = NA,
  headerCache = NULL,
  fillPrecursorScan = FALSE,
  deprofile = getOption("RMassBank")$deprofile,
  trace = "ms2tic"
)
}
\arguments{
\item{msRaw}{The mzR raw file}

\item{mz}{Mass to find}

\item{limit.coarse}{Allowed mass deviation for scan precursor (in m/z values)}

\item{limit.fine}{Unused here, but present for interface compatiblity with findMsMsHR}

\item{rtLimits}{Unused here, but present for interface compatiblity with findMsMsHR}

\item{maxCount}{Maximal number of spectra to return}

\item{headerCache}{Cached results of header(msRaw), either to speed up the operations or to operate with
preselected header() data}

\item{fillPrecursorScan}{Unused here, but present for interface compatiblity with findMsMsHR}

\item{deprofile}{Whether deprofiling should take place, and what method should be
used (cf. \code{\link{deprofile}})}

\item{trace}{Either \code{"ms2tic"} or \code{"ms2basepeak"}: Which intensity trace to use - can be either the
TIC of the MS2 or the basepeak intensity of the MS2.}
}
\value{
a list of "spectrum sets" as defined in \code{\link{findMsMsHR}}, sorted
			by decreasing precursor intensity.
}
\description{
Extract an MS/MS spectrum or multiple MS/MS spectra based on the TIC of the MS2 and precursor mass, picking
the most intense MS2 scan. Can be used, for example, to get a suitable MS2 from direct infusion data which was
collected with purely targeted MS2 without MS1.
}
\details{
Note that this is not a precise function and only really makes sense in direct infusion and if
the precursor is really known, because MS2 precursor data is only "roughly" accurate (to 2 dp).
The regular \code{findMsMsHR} functions confirm the exact mass of the precursor in the MS1 scan.
}
\author{
stravsmi
}
