% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMassBank.R
\name{.parseTitleString}
\alias{.parseTitleString}
\title{Parse record title}
\usage{
.parseTitleString(mbdata)
}
\arguments{
\item{mbdata}{list
The information data block for the record header, as stored in
\code{mbdata_relisted} after loading an infolist.}
}
\value{
A string with the title.
}
\description{
Parses a title for a single MassBank record using the title format
specified in the option titleFormat. Internally used, not exported.
}
\details{
If the option is not set, a standard title format is used (for record definition
version 1 or 2).
}
\examples{
\dontrun{
		# used in buildRecord()
		title <- .parseTitleString(mbdata)
}



}
\references{
MassBank record format:
\url{http://www.massbank.jp/manuals/MassBankRecord_en.pdf}
}
\seealso{
\code{\link{buildRecord}}
}
\author{
Michael Stravs, Eawag
}
