% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethod.R
\name{postTreatment}
\alias{postTreatment}
\title{A post-treatment function to merge closely positioned nucleosomes,
from the same chromosome, identified by the \code{\link{rjmcmc}} function.}
\usage{
postTreatment(reads, seqName = NULL, resultRJMCMC, extendingSize = 74L,
  chrLength)
}
\arguments{
\item{reads}{a \code{GRanges} containing forward and
reverse reads. Beware that the start position of
a reverse read is always higher that the end positition.}

\item{seqName}{a \code{character} string containing the label of the
chromosome, present in the \code{GRanges} object, that will be used. The
\code{NULL} value is accepted when only one seqname is
present in the \code{GRanges}; the only seqname present will be used.
Default: \code{NULL}.}

\item{resultRJMCMC}{an object of \code{class}
"rjmcmcNucleosomes" or "rjmcmcNucleosomesMerge", the information
about nucleosome positioning for an entire chromosome or a region that must
be treated as one unit.}

\item{extendingSize}{a positive \code{numeric} or a positive \code{integer}
indicating the size of the consensus region used to group closeley
positioned nucleosomes.The minimum size of the consensus region is equal to
twice the value of the \code{extendingSize} parameter. The numeric will
be treated as an integer. Default: 74.}

\item{chrLength}{a positive \code{numeric} or a positive \code{integer}
indicating the length of the current chromosome. The length of the
chromosome is used to ensure that the consensus positions are all
located inside the chromosome.}
}
\value{
a \code{GRanges}, the updated nucleosome positions.
When no nucleosome is present, \code{NULL} is returned.
}
\description{
A helper function which merges closely positioned nucleosomes
to rectify the over splitting and provide a more conservative approach.
Beware that each chromosome must be treated separatly.
}
\examples{

## Loading dataset
data(reads_demo_02)

## Nucleosome positioning, running both merge and split functions
result <- rjmcmc(reads = reads_demo_02,
            seqName = "chr_SYNTHETIC", nbrIterations = 1000,
            lambda = 2, kMax = 30, minInterval = 146,
            maxInterval = 490, minReads = 3, vSeed = 11)

## Before post-treatment
result

##Post-treatment function which merged closely positioned nucleosomes
postResult <- postTreatment(reads = reads_demo_02,
                    seqName = "chr_SYNTHETIC", result, 100, 73500)

## After post-treatment
postResult

}
\author{
Pascal Belleau, Astrid Deschenes
}
