% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethod.R
\name{plotNucleosomes}
\alias{plotNucleosomes}
\title{Generate a graph of nucleosome positions with read coverage}
\usage{
plotNucleosomes(nucleosomePositions, reads, seqName = NULL,
  xlab = "position", ylab = "coverage", names = NULL)
}
\arguments{
\item{nucleosomePositions}{a \code{GRanges} or a \code{GRangesList}
containing the nucleosome positions for one or
multiples predictions obtained using the same reads. In presence of
only one prediction (with multiples nucleosome positions), a \code{GRanges}
is used. In presence of more thant one predictions (as example, before and
after post-treatment or results from different software), a
\code{GRangesList} with one entry per prediction is used.}

\item{reads}{a \code{GRanges} containing forward and
reverse reads. The \code{GRanges} should contain at least one read.}

\item{seqName}{a \code{character} string containing the label of the
chromosome, present in the \code{GRanges} object, that will be used. The
\code{NULL} value is accepted when only one seqname is
present in the \code{GRanges}; the only seqname present will be used.
Default: \code{NULL}.}

\item{xlab}{a \code{character} string containing the label of the x-axis.}

\item{ylab}{a \code{character} string containing the label of the y-axis.}

\item{names}{a \code{vector} of a \code{character} string containing the
label of each prediction set. The \code{vector} must be the same length of
the \code{nucleosomePositions} \code{list} or 1 in presence of a
\code{vector}. When \code{NULL}, the name of the elements of the \code{list}
are used or the string "Nucleosome" for a \code{vector} are used.
Default: \code{NULL}.}
}
\value{
a graph containing the nucleosome positions and the read coverage
}
\description{
Generate a graph for
a \code{GRanges} or a \code{GRangesList} of nucleosome positions. In
presence of only one prediction (with multiples nucleosome positions), a
\code{GRanges} is used. In presence of more thant one predictions (as
example, before and after post-treatment or results from
different software), a \code{GRangesList} with
one entry per prediction is used. All predictions must have been obtained
using the same reads.
}
\examples{

## Load reads dataset
data(reads_demo_01)

## Run RJMCMC method
result <- rjmcmc(reads = reads_demo_01,
            seqName = "chr_SYNTHETIC",
            nbrIterations = 4000, lambda = 2, kMax = 30,
            minInterval = 146, maxInterval = 292, minReads = 5,
            vSeed = 10213)

## Create graph using the synthetic map
plotNucleosomes(nucleosomePositions = result$mu, seqName = "chr_SYNTHETIC",
            reads = reads_demo_01)

}
\author{
Astrid Deschenes
}
