% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethod.R
\name{mergeRDSFiles}
\alias{mergeRDSFiles}
\title{Merge nucleosome information from selected RDS files.}
\usage{
mergeRDSFiles(RDSFiles)
}
\arguments{
\item{RDSFiles}{a \code{array}, the
names of all RDS used to merge nucleosome information. The files must
contain R object of \code{class} "rjmcmcNucleosomes" or
"rjmcmcNucleosomesMerge".}
}
\value{
a \code{list} of \code{class} "rjmcmcNucleosomesMerge" containing:
\itemize{
    \item k a \code{integer}, the number of nucleosomes.
    \item \code{mu} a \code{GRanges} containing the positions of the
nucleosomes.
}
}
\description{
Merge nucleosome information present in RDS files into one
object of \code{class} "rjmcmcNucleosomesMerge".
}
\examples{

## Use RDS files present in the RJMCMC package
RDSFiles <- dir(system.file("extdata", package = "RJMCMCNucleosomes"),
full.names = TRUE, pattern = "*RDS")

## Merge nucleosomes info from RDS files present in directory
result <- mergeRDSFiles(RDSFiles)

## Print the number and the position of the nucleosomes
result$k
result$mu

## Class of the output object
class(result)


}
\author{
Pascal Belleau, Astrid Deschenes
}
