% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcRIVER.R
\name{mleBeta}
\alias{mleBeta}
\title{Maximum likelihoood estimate of beta.}
\usage{
mleBeta(Feat, FuncRv, costs)
}
\arguments{
\item{Feat}{Genomic features (G)}

\item{FuncRv}{Soft-assignments of FR from E-step}

\item{costs}{Candidate penalty parameter values for L2-regularization within
logistic regression.}
}
\value{
MLE of beta
}
\description{
\code{mleBeta} computes maximum likelihoood estimate of beta (parameters
        between FR (functionality of regulatory variant) and G (genomic
        annotations); multivariate logistic regression).
}
\section{Warning}{
 To input a vector of candidate penalty values makes
        \code{glmnet} faster than to input a single penalty value
}

\examples{
dataInput <- getData(filename=system.file("extdata", "simulation_RIVER.gz",
        package = "RIVER"), ZscoreThrd=1.5)
Feat <- scale(t(Biobase::exprs(dataInput))) # genomic features (G)
Out <- as.vector(as.numeric(unlist(dataInput$Outlier))-1) # outlier status (E)
theta.init <- matrix(c(.99, .01, .3, .7), nrow=2)
costs <- c(100, 10, 1, .1, .01, 1e-3, 1e-4)
logisticAllCV <- glmnet::cv.glmnet(Feat, Out, lambda=costs, family="binomial",
        alpha=0, nfolds=10)
probFuncRvFeat <- getFuncRvFeat(Feat, logisticAllCV$glmnet.fit, logisticAllCV$lambda.min)
posteriors <- getFuncRvPosteriors(Out, probFuncRvFeat, theta=theta.init)
logistic.cur <- mleBeta(Feat, FuncRv=posteriors$posterior, costs)

}
\seealso{
\code{\link[glmnet]{glmnet}}
}
\author{
Yungil Kim, \email{ipw012@gmail.com}
}
