% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFLOMICS-Methods_02_set_stat_model.R
\name{generateExpressionContrast}
\alias{generateExpressionContrast}
\alias{generateExpressionContrast,RflomicsSE-method}
\alias{generateExpressionContrast,RflomicsMAE-method}
\alias{setSelectedContrasts}
\alias{setSelectedContrasts,RflomicsMAE-method}
\alias{setSelectedContrasts,RflomicsSE-method}
\alias{getSelectedContrasts}
\alias{getSelectedContrasts,RflomicsMAE-method}
\alias{getSelectedContrasts,RflomicsSE-method}
\title{Contrast expressions}
\usage{
\S4method{generateExpressionContrast}{RflomicsSE}(object, contrastType = NULL)

\S4method{generateExpressionContrast}{RflomicsMAE}(object, contrastType = NULL)

\S4method{setSelectedContrasts}{RflomicsMAE}(object, contrastList = NULL)

\S4method{setSelectedContrasts}{RflomicsSE}(object, contrastList = NULL)

\S4method{getSelectedContrasts}{RflomicsMAE}(object)

\S4method{getSelectedContrasts}{RflomicsSE}(object)
}
\arguments{
\item{object}{an object of class \link{RflomicsSE} or 
class \link{RflomicsMAE-class}}

\item{contrastType}{type of contrasts from which the possible 
contrasts are extracted ("average", "simple", "interaction"). 
Default is all contrasts types.}

\item{contrastList}{a data.frame of contrasts generated by 
\link{generateExpressionContrast}}
}
\value{
list of 1 or 3 data.frames of contrast expression

an object of \link{RflomicsSE} class or \link{RflomicsMAE-class}
 class
}
\description{
Generate expression of contrasts based on chosed model formula.
\itemize{
   \item generateExpressionContrast:
 This function allows, from a model formulae, to give the 
 expression contrast data frames.
 Three types of contrasts are expressed:
 \itemize{
 \item pairwise comparison 
 \item averaged expression 
 \item interaction expression 
}}

\itemize{
   \item setSelectedContrasts: 
 Set the selected contrasts stored in \code{metadata} slot}

\itemize{
   \item getSelectedContrasts:
 List the selected contrasts}
}
\examples{
library(RFLOMICS)

# load ecoseed data
data(ecoseed.mae)

factorInfo <- data.frame(
  "factorName"   = c("Repeat", "temperature", "imbibition"),
  "factorType"   = c("batch", "Bio", "Bio")
)

# create rflomicsMAE object with ecoseed data
MAE <- RFLOMICS::createRflomicsMAE(
  projectName = "Tests",
  omicsData   = ecoseed.mae,
  omicsTypes  = c("RNAseq","proteomics","metabolomics"),
  factorInfo  = factorInfo)

# generate all statistical model formulae
formulae <- generateModelFormulae(MAE)

# chose and set model formula to rflomicsMAE object
MAE <- setModelFormula(MAE, formulae[[1]])

# Generate expression of contrasts from chosen model
contrastList <- generateExpressionContrast(MAE, "averaged")

# Set the contrasts List and choose the first 3 contrasts of type averaged
MAE <- setSelectedContrasts(MAE, contrastList = contrastList[c(1,2,3),])

}
\author{
Christine Paysant-Le Roux, adapted by Nadia Bessoltane
}
