% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{patientsSBSPlot}
\alias{patientsSBSPlot}
\title{patientsSBSPlot}
\usage{
patientsSBSPlot(
  trinucleotides_counts,
  samples = rownames(trinucleotides_counts),
  freq = FALSE,
  xlabels = FALSE
)
}
\arguments{
\item{trinucleotides_counts}{Trinucleotides counts matrix.}

\item{samples}{Name of the samples. This should match a rownames in trinucleotides_counts.}

\item{freq}{Boolean value; shall I display rates instead of counts?}

\item{xlabels}{Boolean value; shall I display x labels?}
}
\value{
A ggplot2 object.
}
\description{
Plot Single Base Substitutions (SBS) counts for a set of given patients.
}
\examples{
data(plot_data_examples)
counts <- plot_data_examples[['patients.SBS.plot']][['counts']]
patientsSBSPlot(trinucleotides_counts=counts,samples=rownames(counts)[seq_len(2)])

}
