% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCyjs-class.R
\name{setNodeSizeRule,RCyjs-method}
\alias{setNodeSizeRule,RCyjs-method}
\alias{setNodeSizeRule}
\title{setNodeSizeRule}
\usage{
\S4method{setNodeSizeRule}{RCyjs}(obj, attribute, control.points, node.sizes)
}
\arguments{
\item{obj}{an RCyjs instance}

\item{attribute}{a character string, the node attribute category whose value controls size}

\item{control.points}{a list of values of the attribute}

\item{node.sizes}{the corresponding node size, one specified for each of the control.points}
}
\value{
no return value
}
\description{
\code{setNodeSizeRule} control node size via values of the specified attribute
}
\details{
actual node sizes are interpolated via the specified relationship of control.points node.sizes
}
\examples{
if(interactive()){
   g <- simpleDemoGraph()
   rcy <- RCyjs(title="rcyjs demo", graph=g)
   layout(rcy, "cose")
   fit(rcy, 100)
   setNodeSizeRule(rcy, "count", c(0, 30, 110), c(20, 50, 100));
   redraw(rcy)
   }

}
