% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sandbox.R
\name{sandboxRemove}
\alias{sandboxRemove}
\title{sandboxRemove}
\usage{
sandboxRemove(sandboxName = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{sandboxName}{Name of sandbox to delete. None means to delete the current sandbox. If that sandbox is the default sandbox, it is automatically re-created.}

\item{base.url}{Ignore unless you need to specify a custom domain, port or version to connect to the CyREST API. Default is http://127.0.0.1:1234 and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
dict: {'sandboxPath': <directory on Cytoscape workstation>, 'existed': <True if sandbox existed>}
}
\description{
Delete sandbox contents and remove its directory.
If the current sandbox is the entire file system on a Cytoscape workstation, trying to delete it
is an error. Otherwise, deleting the current sandbox results in the default sandbox becoming the
new current sandbox. When running standalone on the same workstation as Cytoscape, the default
sandbox is the entire file system on the Cytoscape workstation. When running in a Notebook or
remote server, the default sandbox is the 'default_sandbox' created automatically under the
under the filetransfer directory in the CytoscapeConfiguration directory. If that sandbox is
deleted, it will be re-created so that subsequent file operations can complete successfully.
}
\examples{
\donttest{
sandboxRemove()
}
}
