% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layouts.R
\name{getLayoutPropertyValue}
\alias{getLayoutPropertyValue}
\title{Get Layout Property Value}
\usage{
getLayoutPropertyValue(layout.name, property.name, base.url = .defaultBaseUrl)
}
\arguments{
\item{layout.name}{(\code{character}) Name of the layout}

\item{property.name}{(\code{character}) Name of the property}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
The current value set for this layout property. Typically an \code{integer}, \code{numeric} or \code{character} string value.
}
\description{
Returns the appropriately typed value of the specified tunable property for the specified layout.
}
\details{
Run \link{getLayoutNames} to list available layouts. Run \link{getLayoutPropertyNames} to list properties per layout.
}
\examples{
\donttest{
getLayoutPropertyValue('force-directed','defaultSpringLength')
# 80
}
}
\author{
Alexander Pico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
