% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layouts.R
\name{getLayoutPropertyNames}
\alias{getLayoutPropertyNames}
\title{Get Layout Property Names}
\usage{
getLayoutPropertyNames(layout.name, base.url = .defaultBaseUrl)
}
\arguments{
\item{layout.name}{(\code{character}) Name of the layout}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
A \code{list} of \code{character} strings
}
\description{
Returns a list of the tunable properties for the specified layout.
}
\details{
Run \link{getLayoutNames} to list available layouts.
}
\examples{
\donttest{
getLayoutPropertyNames('force-directed')
# [1] "numIterations"            "defaultSpringCoefficient" "defaultSpringLength"         
# [4] "defaultNodeMass"          "isDeterministic"          "singlePartition"     
}
}
\author{
Alexander Pico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
