% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-SubNetworks.R
\name{updateCySubNetworks}
\alias{updateCySubNetworks}
\alias{updateCySubNetworks.CySubNetworksAspect}
\alias{updateCySubNetworks.RCX}
\title{Update Cytoscape subnetworks}
\usage{
updateCySubNetworks(
  x,
  cySubNetworks,
  stopOnDuplicates = FALSE,
  keepOldIds = TRUE,
  ...
)

\method{updateCySubNetworks}{CySubNetworksAspect}(
  x,
  cySubNetworks,
  stopOnDuplicates = FALSE,
  keepOldIds = TRUE,
  ...
)

\method{updateCySubNetworks}{RCX}(
  x,
  cySubNetworks,
  stopOnDuplicates = FALSE,
  keepOldIds = TRUE,
  checkReferences = TRUE,
  ...
)
}
\arguments{
\item{x}{\link[=RCX-object]{RCX} or \code{\link{CySubNetworks}} object; (to which the new subnetworks will be added)}

\item{cySubNetworks}{\code{\link{CySubNetworks}} object; (the subnetwork, that will be added)}

\item{stopOnDuplicates}{logical; whether to stop, if duplicates in \emph{id} column are found, or re-assign ids instead.}

\item{keepOldIds}{logical; if ids are re-assigned, the original ids are kept in the column \emph{oldId}}

\item{...}{additional parameters}

\item{checkReferences}{logical; whether to check if references to other aspects are present in the \link[=RCX-object]{RCX} object}
}
\value{
\code{\link{CySubNetworks}} or \link[=RCX-object]{RCX} object with added subnetworks
}
\description{
This functions add subnetworks in the form of a \code{\link{CySubNetworks}} object to an other \code{\link{CySubNetworks}} or an \link[=RCX-object]{RCX} object.
}
\details{
Cytoscape subnetworks allow to group a set of nodes and corresponding edges together.
\code{\link{CySubNetworks}} objects can be added to an \link[=RCX-object]{RCX} or an other \code{\link{CySubNetworks}} object.
The \emph{nodes} and \emph{edges} parameters reference the node or edge IDs that belong to a subnetwork.
When adding an \code{\link{CySubNetworks}} object to an \link[=RCX-object]{RCX} object, those IDs must be present in the
\code{\link{Nodes}} or \code{\link{Edges}} aspect respectively, otherwise an error is raised.
Unlike other aspects referring those IDs, the Cytoscape subnetwork aspect allows to refer to all nodes and edges using the keyword \code{all}.

When subnetworks should be added to a \code{\link{CySubNetworks}} or a \link[=RCX-object]{RCX} object some conflicts may rise, since the
aspects might use the same IDs. If the aspects do not share any IDs, the two aspects are simply combined.
Otherwise, the IDs of the new subnetworks are re-assinged continuing with the next available ID
(i.e. \code{\link{maxId}}(cySubNetworks) + 1 and \code{\link{maxId}}(rcx$cySubNetworks) + 1, respectively).

To keep track of the changes, it is possible to keep the old IDs of the newly added nodes in the automatically added column \emph{oldId}.
This can be omitted by setting \emph{keepOldIds} to \code{FALSE}.
Otherwise, if a re-assignment of the IDs is not desired, this can be prevented by setting \emph{stopOnDuplicates} to \code{TRUE}.
This forces the function to stop and raise an error, if duplicated IDs are present.
}
\examples{
## For CySubNetworksAspects: 
## prepare some aspects:
cySubNetworks1 = createCySubNetworks(
  id = c(0,1),
  nodes = list("all",
               c(1,2,3)),
  edges = list("all",
               c(0,2))                    
)

cySubNetworks2 = createCySubNetworks(
  nodes = c(0,3),
  edges = c(1)
)

## subnetwork ids will be kept
cySubNetworks3 = updateCySubNetworks(cySubNetworks1, cySubNetworks2)

## old subnetwork ids will be omitted
cySubNetworks3 = updateCySubNetworks(cySubNetworks1, cySubNetworks2,
                                     keepOldIds=FALSE)

## Raise an error if duplicate keys are present
try(updateCySubNetworks(cySubNetworks1, cySubNetworks2,
                        stopOnDuplicates=TRUE))
## =>ERROR: 
## Elements of "id" (in updateCySubNetworks) must not contain duplicates!

## For RCX
## prepare RCX object:
nodes = createNodes(name = c("a","b","c","d","e","f"))
edges = createEdges(source=c(1,2,0,0,0,2), 
                    target=c(2,3,1,2,5,4))
rcx = createRCX(nodes, edges)

## add the subnetwork
rcx = updateCySubNetworks(rcx, cySubNetworks1)

## add additional subnetwork
rcx = updateCySubNetworks(rcx, cySubNetworks2)

## create a subnetwork with a not existing node...
cySubNetworks3 = createCySubNetworks(
  nodes = list(9)
)

## ...and try to add them
try(updateCySubNetworks(rcx, cySubNetworks3))
## =>ERROR: 
## Provided IDs of "additionalSubNetworks$nodes" (in addCySubNetworks) 
## don't exist in "rcx$nodes$id"

## create a group with a not existing edge...
cySubNetworks4 = createCySubNetworks(
  nodes = c(0,1),
  edges = 9
)

## ...and try to add them
try(updateCySubNetworks(rcx, cySubNetworks4))
## =>ERROR: 
## Provided IDs of "additionalSubNetworks$edges" (in addCySubNetworks) 
## don't exist in "rcx$edges$id"
}
\seealso{
\code{\link{CyNetworkRelations}};
}
