% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Summary.R
\name{summary}
\alias{summary}
\alias{summary.RCX}
\alias{summary.MetaDataAspect}
\alias{summary.NodesAspect}
\alias{summary.EdgesAspect}
\alias{summary.NodeAttributesAspect}
\alias{summary.EdgeAttributesAspect}
\alias{summary.NetworkAttributesAspect}
\alias{summary.CartesianLayoutAspect}
\alias{summary.CyGroupsAspect}
\alias{summary.CyHiddenAttributesAspect}
\alias{summary.CyNetworkRelationsAspect}
\alias{summary.CySubNetworksAspect}
\alias{summary.CyTableColumnAspect}
\alias{summary.CyVisualPropertiesAspect}
\alias{summary.CyVisualProperty}
\alias{summary.AspectIdColumn}
\alias{summary.AspectRefColumn}
\alias{summary.AspectReqRefColumn}
\alias{summary.AspectValueColumn}
\alias{summary.AspectAttributeColumn}
\alias{summary.AspectListLengthColumn}
\title{RCX and aspect summary}
\usage{
\method{summary}{RCX}(object, ...)

\method{summary}{MetaDataAspect}(object, ...)

\method{summary}{NodesAspect}(object, ...)

\method{summary}{EdgesAspect}(object, ...)

\method{summary}{NodeAttributesAspect}(object, ...)

\method{summary}{EdgeAttributesAspect}(object, ...)

\method{summary}{NetworkAttributesAspect}(object, ...)

\method{summary}{CartesianLayoutAspect}(object, ...)

\method{summary}{CyGroupsAspect}(object, ...)

\method{summary}{CyHiddenAttributesAspect}(object, ...)

\method{summary}{CyNetworkRelationsAspect}(object, ...)

\method{summary}{CySubNetworksAspect}(object, ...)

\method{summary}{CyTableColumnAspect}(object, ...)

\method{summary}{CyVisualPropertiesAspect}(object, ...)

\method{summary}{CyVisualProperty}(object, ...)

\method{summary}{AspectIdColumn}(object, ...)

\method{summary}{AspectRefColumn}(object, ...)

\method{summary}{AspectReqRefColumn}(object, ...)

\method{summary}{AspectValueColumn}(object, ...)

\method{summary}{AspectAttributeColumn}(object, ...)

\method{summary}{AspectListLengthColumn}(object, ...)
}
\arguments{
\item{object}{an object; \link[=RCX-object]{RCX} object or aspect (or column of data.frame)}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
object summary as list
}
\description{
\code{summary} is a generic function used to produce result summaries of the \link[=RCX-object]{RCX} object.
The function invokes particular methods which depend on the class of the first argument.
}
\details{
The form of the returned summary depends on the class of its argument, therefore it is possible to summarize
\link[=RCX-object]{RCX} objects and their single aspects.

To enhance readability of the summary, some additional classes have \code{summary} functions, that are used to show
for example ids of an aspect, required and optional references to ids of aspects, or the number of elements in lists.
}
\section{Methods (by class)}{
\itemize{
\item \code{summary(AspectIdColumn)}: Summarize an id property

\item \code{summary(AspectRefColumn)}: Summarize an optional property, that references the ids of an other aspect

\item \code{summary(AspectReqRefColumn)}: Summarize a required property, that references the ids of an other aspect

\item \code{summary(AspectValueColumn)}: Summarize the occurrences of the different elements in the property

\item \code{summary(AspectAttributeColumn)}: Summarize the different attributes in the property

\item \code{summary(AspectListLengthColumn)}: The property is a list of vectors, so summarize the length of the vectors

}}
\examples{
rcx = createRCX(
  nodes = createNodes(name = c("a","b","c")),
  edges = createEdges(source=1, target=2)
)

summary(rcx)
}
