% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_checkAlias.R
\name{checkAlias}
\alias{checkAlias}
\title{Check for alias structures in a dataframe, and throw an error when one is found}
\usage{
checkAlias(datFrame, covariatesNames)
}
\arguments{
\item{datFrame}{the data frame to be checked for alias structure}

\item{covariatesNames}{The names of the variables to be considered}
}
\value{
Throws an error when an alias structure is detected,
returns invisible otherwise
}
\description{
Check for alias structures in a dataframe, and throw an error when one is found
}
\examples{
#Make a dataframe with aliased variables
df = data.frame(foo = rnorm(10), baa = rep(c(TRUE, FALSE), each = 5),
foo2 = factor(rep(c("male", "female"), each = 5)))
checkAlias(df, c("foo", "baa"))
#Check test files for the error being thrown
}
