% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_LR_nb.R
\name{LR_nb}
\alias{LR_nb}
\title{Get the value of the log-likelihood ratio of alpha}
\usage{
LR_nb(
  Alpha,
  X,
  CC,
  responseFun = c("linear", "quadratic", "nonparametric", "dynamic"),
  muMarg,
  psi,
  nleqslv.control = list(trace = FALSE),
  n,
  NB_params,
  NB_params_noLab,
  thetaMat,
  ncols,
  nonParamRespFun,
  envGradEst,
  ...
)
}
\arguments{
\item{Alpha}{a vector of length d, the environmental gradient}

\item{X}{the n-by-p count matrix}

\item{CC}{the n-by-d covariate matrix}

\item{responseFun}{a character string indicating
the type of response function}

\item{muMarg}{an n-by-p offset matrix}

\item{psi}{a scalar, an importance parameter}

\item{nleqslv.control}{the control list for the nleqslv() function}

\item{n}{number of samples}

\item{NB_params}{Starting values for the NB_params}

\item{NB_params_noLab}{Starting values for the NB_params without label}

\item{thetaMat}{a matrix of size n-by-p with estimated dispersion parameters}

\item{ncols}{a scalar, the number of columns of X}

\item{nonParamRespFun}{A list, the result of the estNPresp() function}

\item{envGradEst}{a character string,
indicating how the environmental gradient should be fitted.
'LR' using the likelihood-ratio criterion,
or 'ML' a full maximum likelihood solution}

\item{...}{Further arguments passed on to other functions

DON'T USE 'p' as variable name,
 partial matching in the grad-function in the numDeriv package}
}
\value{
: a scalar, the evaluation of the log-likelihood ratio
 at the given alpha
}
\description{
Get the value of the log-likelihood ratio of alpha
}
