% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_functions.R
\name{queryGff}
\alias{queryGff}
\title{queryGff}
\usage{
queryGff(queryRegions, gffData)
}
\arguments{
\item{queryRegions}{GRanges object imported from a BED file using
\code{importBed} function}

\item{gffData}{GRanges object imported from a GTF file using \code{importGtf}
function}
}
\value{
a GRanges object (a subset of input gff) with an additional column
  'overlappingQuery' that contains the coordinates of query regions that
  overlap the target annotation features
}
\description{
This function checks overlaps between the regions in input query and in
reference. Input query should be in BED format and reference should be in GFF
format. Both data are imported as GRanges object.
}
\examples{
data(queryRegions)
data(gff)
overlaps <- queryGff(queryRegions = queryRegions, gffData = gff)

}
