% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateComputePCAMultiSynthetic}
\alias{validateComputePCAMultiSynthetic}
\title{Validate the input parameters for computePCAMultiSynthetic()
function}
\usage{
validateComputePCAMultiSynthetic(
  gdsProfile,
  listPCA,
  sampleRef,
  studyIDSyn,
  verbose
)
}
\arguments{
\item{gdsProfile}{an object of class \link[gdsfmt]{gds.class} (a GDS file),
an opened Profile GDS file.}

\item{listPCA}{a \code{list} containing the PCA \code{object} generated
with the 1KG reference profiles (excluding the ones used to generate the
synthetic data set) in an entry called \code{"pca.unrel"}.}

\item{sampleRef}{a \code{vector} of \code{character} strings representing
the identifiers of the 1KG reference profiles that should not be used to
create the reference PCA.}

\item{studyIDSyn}{a \code{character} string corresponding to the study
identifier. The study identifier must be present in the Profile GDS file.}

\item{verbose}{a \code{logical} indicating if messages should be printed
to show how the different steps in the function.}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function validates the input parameters for the
\code{\link{computePCAMultiSynthetic}} function.
When a parameter is not as expected, an error message is generated.
}
\examples{

## Loading demo PCA on subset of 1KG reference dataset
data(demoPCA1KG)

## Path to the demo GDS file is located in this package
dataDir <- system.file("extdata/demoKNNSynthetic", package="RAIDS")
fileProfileGDS <- file.path(dataDir, "ex1.gds")

## Open GDS files
gdsProfile <- openfn.gds(fileProfileGDS)

## The function returns 0L when all parameters are valid
RAIDS:::validateComputePCAMultiSynthetic(gdsProfile=gdsProfile,
    listPCA=demoPCA1KG, sampleRef=c("HG00246", "HG00325"),
    studyIDSyn="MyStudy", verbose=FALSE)

## Close GDS file (it is important to always close the GDS files)
closefn.gds(gdsProfile)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
