% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelicFraction_internal.R
\encoding{UTF-8}
\name{computeLOHBlocksDNAChr}
\alias{computeLOHBlocksDNAChr}
\title{Identify regions of LOH on one chromosome using homozygote SNVs}
\usage{
computeLOHBlocksDNAChr(gdsReference, chrInfo, snpPos, chr, genoN = 1e-04)
}
\arguments{
\item{gdsReference}{an object of class
\code{\link[SNPRelate:SNPGDSFileClass]{SNPRelate::SNPGDSFileClass}}, an
opened Reference GDS file.}

\item{chrInfo}{a \code{vector} of \code{integer} representing the length of
the chromosomes. As an example, the information ca be obtained from
package 'BSgenome.Hsapiens.UCSC.hg38'.}

\item{snpPos}{a \code{data.frame} containing the SNV information for the
chromosome specified by the \code{chr} argument. The \code{data.frame} must
contain:
\describe{
\item{cnt.tot}{ a single \code{integer} representing the total coverage for
the SNV.}
\item{cnt.ref}{ a single \code{integer} representing the coverage for
the reference allele.}
\item{cnt.alt}{ a single \code{integer} representing the coverage for
the alternative allele.}
\item{snp.pos}{ a single \code{integer} representing the SNV position.}
\item{snp.chr}{ a single \code{integer} representing the SNV chromosome.}
\item{normal.geno}{ a single \code{numeric} indicating the genotype of the
SNV. The possibles are: \code{0} (wild-type homozygote), \code{1}
(heterozygote), \code{2} (altenative homozygote), \code{3} indicating that
the normal genotype is unknown.}
\item{pruned}{ a \code{logical} indicating if the SNV is retained after
pruning}
\item{snp.index}{ a \code{integer} representing the index position of the
SNV in the Reference GDS file that contains all SNVs}
\item{keep}{ a \code{logical} indicating if the genotype exists for the SNV}
\item{hetero}{ a \code{logical} indicating if the SNV is heterozygote}
\item{homo}{ a \code{logical} indicating if the SNV is homozygote}
}}

\item{chr}{a single positive \code{integer} for the current chromosome. The
\code{chrInfo} parameter must contain the value for the specified
chromosome.}

\item{genoN}{a single \code{numeric} between 0 and 1 representing the
probability of sequencing error. Default: \code{0.0001}.}
}
\value{
a \code{data.frame} with the informations about LOH on a specific
chromosome. The \code{data.frame} contains those columns:
\describe{
\item{chr}{ a \code{integer} representing the current chromosome}
\item{start}{ a \code{integer} representing the starting position on the
box containing only homozygote SNVs (or not SNV). The first box starts at
position \code{1}.}
\item{end}{ a \code{integer} representing the end position on the
box containing only homozygote SNVs (or not SNV). The last box ends at the
length of the chromosome.}
\item{logLHR}{ a \code{numeric} representing the LOH score basde on
population frequencies. It is the sum of
the log10 of the frequencies of the observed gegenotype minus the
the sum of the log10 of the higher frequent genotype.
(-100 when normal genotype are present)}
\item{LH1}{ a \code{numeric}  representing the probability to be
heterozygote based on the coverage of each allele when normal
genotype is present}
\item{LM1}{ a \code{numeric} representing the max probability
for the read coverage at the position}
\item{homoScore}{ a \code{numeric} representing \code{LH1} - \code{LM1}}
\item{nbSNV}{ a \code{integer} representing th number of SNVs in
the box}
\item{nbPruned}{ a \code{integer} representing the number of pruned SNVs in
the box}
\item{nbNorm}{ a \code{integer} representing of the number of
heterozygote genotypes for the normal SNVs in the block}
\item{LOH}{ a \code{integer} representing a flag, if \code{1} it means
the block is satisfying the criteria to be LOH. The value is not assigned
in this function; the value \code{0} is assigned}
}
}
\description{
The function identifies regions of LOH on a specific
chromosome using the homozygote SNVs present on the chromosome.
}
\examples{

## Required library for GDS
library(SNPRelate)

## Path to the demo Reference GDS file is located in this package
dataDir <- system.file("extdata/tests", package="RAIDS")
fileGDS <- file.path(dataDir, "ex1_good_small_1KG.gds")

## Open the Reference GDS file (demo version)
gds1KG <- snpgdsOpen(fileGDS)

## Required library for this example to run correctly
if (requireNamespace("Seqinfo", quietly=TRUE) &&
     requireNamespace("BSgenome.Hsapiens.UCSC.hg38", quietly=TRUE)) {

    ## Chromosome length information
    ## chr23 is chrX, chr24 is chrY and chrM is 25
    chrInfo <-
        Seqinfo::seqlengths(BSgenome.Hsapiens.UCSC.hg38::Hsapiens)[1:25]

    ## Data frame with SNV information for the specified chromosome (chr 1)
    snpInfo <- data.frame(cnt.tot=c(41, 17, 27, 15, 11, 37, 16, 32),
        cnt.ref=c(40, 17, 27, 15, 4, 14, 16, 32),
        cnt.alt=c(0, 0, 0, 0, 7, 23, 0, 0),
        snp.pos=c(3722256, 3722328, 3767522, 3868160, 3869467, 4712655,
            6085318, 6213145),
        snp.chr=c(rep(1, 8)),
        normal.geno=c(rep(3, 8)), pruned=c(TRUE, TRUE, FALSE, TRUE, FALSE,
            TRUE, TRUE, TRUE),
        pruned=c(TRUE, TRUE, FALSE, TRUE, FALSE, rep(TRUE, 3)),
        snp.index=c(160, 162, 204, 256, 259, 288, 366, 465),
        keep=rep(TRUE, 8), hetero=c(rep(FALSE, 4), TRUE,
            TRUE, rep(FALSE, 2)),
        homo=c(rep(TRUE, 4), FALSE, FALSE, TRUE, TRUE),
        stringAsFactor=FALSE)

    ## The function returns a data frame containing the information about
    ## the LOH regions in the specified chromosome
    result <- RAIDS:::computeLOHBlocksDNAChr(gdsReference=gds1KG,
        chrInfo=chrInfo, snpPos=snpInfo, chr=1L, genoN=0.0001)
    head(result)

    ## Close Reference GDS file (important)
    closefn.gds(gds1KG)

}

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
