% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{addUpdateSegment}
\alias{addUpdateSegment}
\title{Add information related to segments associated to the SNV
dataset for a specific sample into a GDS file}
\usage{
addUpdateSegment(gdsProfile, snpSeg)
}
\arguments{
\item{gdsProfile}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), a GDS Sample file.}

\item{snpSeg}{a \code{vector} of \code{integer} representing the segment
identifiers associated to each SNV selected for the specific sample. The
length of the \code{vector} should correspond to the number of SNVs
present in the "snp.id" entry of the GDS sample file.}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function adds the information related to segments
associated to the SNV dataset for a specific sample into a
GDS file, more specifically, in the "segment" node. If the "segment" node
already exists, the previous information is erased.
}
\examples{

## Required library
library(gdsfmt)

## Temporary GDS file
gdsFilePath <- file.path(tempdir(), "GDS_TEMP.gds")

## Create and open the GDS file
GDS_file_tmp  <- createfn.gds(filename=gdsFilePath)

## Vector of segment identifiers
segments <- c(1L, 1L, 1L, 2L, 2L, 3L, 3L)

## Add segments to the GDS file
RAIDS:::addUpdateSegment(gdsProfile=GDS_file_tmp, snpSeg=segments)

## Read segments information from GDS file
read.gdsn(index.gdsn(node=GDS_file_tmp, path="segment"))

## Close GDS file
closefn.gds(gdsfile=GDS_file_tmp)

## Delete the temporary GDS file
unlink(x=gdsFilePath, force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
