% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rank_x}
\alias{rank_x}
\title{Retrieve indices of \eqn{x_i}'s after merging \eqn{\boldsymbol{x}} and
\eqn{\boldsymbol{y}} in ascending order.}
\usage{
rank_x(x, y = NULL, ties.break = TRUE)
}
\arguments{
\item{x}{First sample}

\item{y}{Second sample}

\item{ties.break}{Whether to break the ties when ordering \code{x} and \code{y}.
Default is \code{'TRUE'}.}
}
\value{
Ranks of \eqn{x_i}'s after merging \code{x} and \code{y} in ascending order
}
\description{
Given data consisting of either a single sample
\eqn{\boldsymbol{x}=(x_1,\ldots,x_k)},
or two samples \eqn{\boldsymbol{x}=(x_1,\ldots,x_k)} and
\eqn{\boldsymbol{y}=(y_1,\ldots,y_n)},
this function obtains the indices of \eqn{x_i}'s after merging
\eqn{\boldsymbol{x}} and \eqn{\boldsymbol{y}} in ascending order.
}
\details{
Dependencies: None
}
\examples{

set.seed(1)
rank_x(x = abs(rnorm(10)))
rank_x(x = abs(rnorm(10)), y = abs(rnorm(100)))
rank_x(
    x = rnbinom(10, size = 5, prob = 0.3),
    y = rnbinom(20, size = 2, prob = 0.3), ties.break = TRUE
)
}
