% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co_apex.R
\name{co_apex}
\alias{co_apex}
\title{Calculate the co-apex score for every protein pair}
\usage{
co_apex(gaussians, proteins = NULL)
}
\arguments{
\item{gaussians}{a list of Gaussian mixture models fit to the profile matrix
by \code{link{build_gaussians}}}

\item{proteins}{all proteins being scored, optionally including those 
without Gaussian fits}
}
\value{
a matrix of co-apex scores
}
\description{
Calculate the co-apex score for every pair of proteins. This is defined as 
the minimum Euclidean distance between any two Gaussians fit to each 
profile.
}
\examples{
data(scott_gaussians)
gauss <- scott_gaussians[seq_len(25)]
CA <- co_apex(gauss)

}
