% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFuncs.R
\name{MissingStats}
\alias{MissingStats}
\title{Calculates the p-values and q-values for missing values in a data frame with
columns as samples and rows as features.}
\usage{
MissingStats(Data, NumCond, NumReps)
}
\arguments{
\item{Data}{A matrix containing the expression data with rows as features and
columns as samples}

\item{NumCond}{The number of conditions in the dataset}

\item{NumReps}{The number of replicates for each condition (needs to be same
for all conditions)}
}
\value{
A list containing the calculated p-values and q-values
(Benjamini-Hochberg) for missingness statistics
}
\description{
Calculates the p-values and q-values for missing values in a data frame with
columns as samples and rows as features.
}
\examples{
Data <- matrix(rnorm(120), nrow = 10)
# Introduce some missingness
Data[sample(1:120, 40)] <- NA
NumCond <- 4
NumReps <- 3
res_misstest <- MissingStats(Data, NumCond, NumReps)
head(res_misstest$qNAvalues)
}
