% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDomainPlot.R
\name{sortDomains}
\alias{sortDomains}
\title{Sort one domain dataframe based on the other domain dataframe}
\usage{
sortDomains(seedDf, orthoDf)
}
\arguments{
\item{seedDf}{data of seed protein}

\item{orthoDf}{data of ortholog protein}
}
\value{
Dataframe contains sorted domain list.
}
\description{
Sort domain dataframe of one protein (either seed or ortholog)
based on the dataframe of the its paired protein, in order to bring the
common domain feature in the same order which make it easy for comparing.
}
\examples{
# get domain data
seedID <- "101621at6656"
domainFile <- system.file(
    "extdata", "domainFiles/101621at6656.domains",
    package = "PhyloProfile", mustWork = TRUE
)
domainDf <- parseDomainInput(seedID, domainFile, "file")
# get seedDf and orthoDf
subDf <- domainDf[
    domainDf$seedID ==
    "101621at6656#101621at6656:AGRPL@224129@0:224129_0:001955:1",]
orthoDf <- subDf[subDf$orthoID == "101621at6656:DROME@7227@1:Q9VG04",]
seedDf <- subDf[subDf$orthoID != "101621at6656:DROME@7227@1:Q9VG04",]
# sort
PhyloProfile:::sortDomains(seedDf, orthoDf)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
