% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMotifFreq.R
\name{frequencyScoring}
\alias{frequencyScoring}
\title{Frequency scoring}
\usage{
frequencyScoring(sequence.list, frequency.mat)
}
\arguments{
\item{sequence.list}{A vector list of sequences}

\item{frequency.mat}{A matrix output from `createFrequencyMat`}
}
\value{
A vector of frequency score
}
\description{
Frequency scoring
}
\examples{

data('phospho_L6_ratio_pe')
data('KinaseMotifs')

# Extracting first 10 sequences for demonstration purpose
seqs = Sequence(phospho.L6.ratio.pe)
seqs = seqs[seq(10)]

# extracting flanking sequences
seqWin = mapply(function(x) {
    mid <- (nchar(x)+1)/2
    substr(x, start=(mid-7), stop=(mid+7))
}, seqs)

# The first 10 for demonstration purpose
phospho.L6.ratio = SummarizedExperiment::assay(phospho.L6.ratio.pe, 
    "Quantification")[seq(10),]

# minimum number of sequences used for compiling motif for each kinase.
numMotif=5

motif.mouse.list.filtered <-
    motif.mouse.list[which(motif.mouse.list$NumInputSeq >= numMotif)]

# scoring all phosphosites against all motifs
motifScoreMatrix <-
    matrix(NA, nrow=nrow(phospho.L6.ratio),
        ncol=length(motif.mouse.list.filtered))
rownames(motifScoreMatrix) <- rownames(phospho.L6.ratio)
colnames(motifScoreMatrix) <- names(motif.mouse.list.filtered)

# Scoring phosphosites against kinase motifs
for(i in seq_len(length(motif.mouse.list.filtered))) {
    motifScoreMatrix[,i] <-
        frequencyScoring(seqWin, motif.mouse.list.filtered[[i]])
    cat(paste(i, '.', sep=''))
}

}
