% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineBeads.R
\name{defineBeads}
\alias{defineBeads}
\alias{getBeadsName}
\alias{setBeadsName}
\title{Defining how beads-only samples are encoded.}
\usage{
getBeadsName()

setBeadsName(name)
}
\arguments{
\item{name}{a string indicating how beads-only samples are encoded.}
}
\value{
a string indicating how beads-only samples are encoded.
}
\description{
\code{getBeadsName} and \code{setBeadsName} are two function to
get and set the string that encodes which samples are beads-only samples.
Information about beads-only samples are stored in the \code{groups} column
of \code{sampleInfo}.
}
\details{
If \code{name} is of length greater than one, only the first element
of the vector is used. Non-character values of \code{name} are first coerced
into strings.
}
\section{Functions}{
\itemize{
\item \code{getBeadsName}: function that returns a string corresponding to how
beads-only samples are encoded.

\item \code{setBeadsName}: function to set the string that indicates which
samples are beads-only samples in the \code{groups} column of
\code{sampleInfo}.
}}

\examples{
## Returns the default string, "beads"
getBeadsName()

## Not run since it changes defaults/user settings
\dontrun{
setBeadsName("beads-only")
}

}
