% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitContrasts.R
\name{FitContrasts}
\alias{FitContrasts}
\title{Empirical Bayes moderated t-test}
\usage{
FitContrasts(
  dat,
  contrasts.par,
  group,
  covar = NULL,
  logged = FALSE,
  NPeptide = NULL
)
}
\arguments{
\item{dat}{a dataframe or matrix of feature (e.g., peptide, protein) abundance}

\item{contrasts.par}{group levels to be compared separated by dash (e.g., "B-A"
if group B is to be compared against group A)}

\item{group}{list of group levels corresponding to each sample. The order of group
levels needs to match that of samples in the feature abundance table.}

\item{covar}{covariate matrix}

\item{logged}{Boolean variable indicating whether data have been log-transformed}

\item{NPeptide}{numeric vector indicating number of peptides aggregated for each protein. logNPeptide will be passed to limma-trend. Constant prior variance if null.}
}
\value{
\code{FitContrasts} returns an object of class \code{MArrayLM}. See ?\code{limma::eBayes} for details.
}
\description{
Fit a linear model to feature abundance and compute moderated t-statistics via the empirical Bayes method.
}
\examples{
# Generate random peptide data
dat <- 2^matrix(rnorm(3000), ncol = 6)
colnames(dat) <- paste0("Sample", 1:6)
rownames(dat) <- paste0("Peptide", 1:500)

# Generate groups and contrasts
group <- c(rep("A", 3), rep("B", 3))
contrasts.par <- "B-A"

# Run moderated t-test without covariates
FitContrasts(dat, contrasts.par, group)

# Run moderated t-test with covariates
covar <- matrix(c(1:6, 0, 1, 0, 1, 1, 0), nrow = 6, ncol = 2, byrow = FALSE)
FitContrasts(dat, contrasts.par, group, covar = covar)

}
\references{
Ritchie, ME, Phipson, B, Wu, D, Hu, Y, Law, CW, Shi, W, and Smyth, GK (2015). limma powers differential expression analyses for RNA-sequencing and microarray studies. \emph{Nucleic Acids Research} 43, e47.
}
\author{
Junmin Wang
}
