% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{miscarriage_to_factor}
\alias{miscarriage_to_factor}
\title{Miscarriage variable to factor}
\usage{
miscarriage_to_factor(miscarriage)
}
\arguments{
\item{miscarriage}{A character, factor or numeric vector corresponding to
the miscarriage status of the individuals. This will be transformed to a
factor with the following levels:
\code{TOP}, \code{SAB}, \code{ECT}, \code{FALSE}
The following values are recognized:
\itemize{
\item "SAB" : "spontaneous", "spontaenous abortion"
\item "TOP" : "termination", "terminated", "termination of pregnancy"
\item "ECT" : "ectopic", "ectopic pregnancy"
\item FALSE : \code{0}, \code{FALSE}, "no", \code{NA}
}}
}
\value{
an factor vector containing the transformed variable
"SAB", "TOP", "ECT", "FALSE"
}
\description{
Transform a miscarriage variable to a factor variable
By default, all other values are transformed to \code{NA} and considered as
\code{FALSE}. Space and case are ignored.
}
\examples{
miscarriage_to_factor(c(
   "spontaneous", "spontaenous abortion",
  "termination", "terminated", "termination of pregnancy",
  "ectopic", "ectopic pregnancy",
  "0", "false", "no", "NA"
))
}
\keyword{internal}
