% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_family_sel.R
\name{family_sel_ui}
\alias{family_sel_ui}
\alias{family_sel_server}
\alias{family_sel_demo}
\title{Shiny module to select a family in a pedigree}
\usage{
family_sel_ui(id)

family_sel_server(
  id,
  pedi,
  fam_var = NULL,
  fam_sel = NULL,
  title = "Family selection",
  help_text = NULL,
  help_title = "Family selection",
  help_colour = "grey",
  help_type = "inline"
)

family_sel_demo(fam_var = NULL, fam_sel = NULL, title = "Family selection")
}
\arguments{
\item{id}{A string to identify the module.}

\item{pedi}{A reactive pedigree object.}

\item{fam_var}{The default family variable to use as family indicator.}

\item{fam_sel}{The default family to select.}

\item{title}{The title of the module.}
}
\value{
A reactive list with the subselected pedigree object and the
selected family id.
}
\description{
This module allows to select a family in a pedigree object.
The function is composed of two parts: the UI and the server.
The UI is called with the function \code{family_sel_ui()} and the server
with the function \code{family_sel_server()}.
}
\examples{
if (interactive()) {
    family_sel_demo()
}
}
\keyword{internal}
