% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetOverview.R
\name{plot_markers_boxplots}
\alias{plot_markers_boxplots}
\title{Boxplots of intensities of specific markers}
\usage{
plot_markers_boxplots(
  se,
  markers,
  ain = NULL,
  id_column = "Protein.IDs",
  color_by = NULL,
  shape_by = NULL,
  facet_norm = TRUE,
  facet_marker = FALSE
)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{markers}{Vector of the IDs of the markers to plot}

\item{ain}{Vector of strings of normalization methods to visualize (must be valid normalization methods saved in de_res)}

\item{id_column}{String specifying the column of the rowData of the SummarizedExperiment object which includes the IDs of the markers}

\item{color_by}{String specifying the column to color the samples (If NULL, the condition column of the SummarizedExperiment object is used. If "No", no color bar added.)}

\item{shape_by}{String specifying the column to shape the samples (If NULL or "No", no shaping of samples is done.)}

\item{facet_norm}{Boolean indicating whether to facet by normalization method (TRUE) or not (FALSE)}

\item{facet_marker}{Boolean indicating whether to facet by comparison (TRUE) or not (FALSE). Only valid if facet_norm = FALSE.}
}
\value{
ggplot object
}
\description{
Boxplots of intensities of specific markers
}
\examples{
data(tuberculosis_TMT_se)
plot_markers_boxplots(tuberculosis_TMT_se, markers = c("Q7Z7F0", "Q13790"),
                     ain = c("log2"), id_column = "Protein.IDs",
                     color_by = NULL,
                     shape_by = "Pool",
                     facet_norm = FALSE,
                     facet_marker = TRUE)

}
