% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpikeDEPlots.R
\name{plot_TP_FP_spiked_scatter}
\alias{plot_TP_FP_spiked_scatter}
\title{Scatterplot of true positives and false positives (median with errorbars as Q1, and Q3) for all comparisons}
\usage{
plot_TP_FP_spiked_scatter(stats, ain = NULL, comparisons = NULL)
}
\arguments{
\item{stats}{data table with multiple metrics of the DE results (resulting of get_spiked_stats_DE)}

\item{ain}{Vector of strings of normalization methods to visualize (must be valid normalization methods saved in stats)}

\item{comparisons}{Vector of comparisons (must be valid comparisons saved in stats)}
}
\value{
ggplot object
}
\description{
Scatterplot of true positives and false positives (median with errorbars as Q1, and Q3) for all comparisons
}
\examples{
data(spike_in_se)
data(spike_in_de_res)
stats <- get_spiked_stats_DE(spike_in_se, spike_in_de_res)
plot_TP_FP_spiked_scatter(stats, ain = NULL, comparisons = NULL)

}
