% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{Simulate2SCE}
\alias{Simulate2SCE}
\title{Simulate the data for two-group comparison; e.g., treatment v.s. control
It simulates the DE changes in two forms corresponding two types of DE genes}
\usage{
Simulate2SCE(n = 100, perDE = 0.05, estParas1, estParas2)
}
\arguments{
\item{n}{the number of total cells for two groups}

\item{perDE}{percentage of DE genes}

\item{estParas1}{the set of parameters corresponding to cell type I}

\item{estParas2}{the set of parameters corresponding to cell type II}
}
\value{
a list of metrics recording the changes in the generated data: such as the DE gene indices for Form I and II DE genes, and simulated expression data in singlecellexperiment format.
}
\description{
Simulate the data for two-group comparison; e.g., treatment v.s. control
It simulates the DE changes in two forms corresponding two types of DE genes
}
\examples{
data("es_mef_sce")
sce = es_mef_sce[, colData(es_mef_sce)$cellTypes == "fibro"]
set.seed(123)
rix = sample(1:nrow(sce), 500)
sce = sce[rix, ]
estParas = Est2Phase(sce)
simData = Simulate2SCE(n=100, estParas1 = estParas, estParas2 = estParas)
}
