% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readPsa.R
\name{readPsa}
\alias{readPsa}
\title{Parse a PSA (PROSITE Scan ASCII) File}
\usage{
readPsa(psa_file)
}
\arguments{
\item{psa_file}{A character string specifying the path to the input PSA file.}
}
\value{
A data frame with a GFF-like structure.
}
\description{
This function reads a file in PSA format and converts it into a
standardized, GFF-like data frame for downstream analysis. It ensures
compatibility with data frames generated by rtracklayer::import.gff
by matching column types and order.
}
\examples{
# Get path to example file
psa_file <- system.file("extdata", "out_Hb_psa.txt", package = "PMScanR")

if (nzchar(psa_file) && file.exists(psa_file)) {
  psa_data <- readPsa(psa_file)
  head(psa_data)
}
}
