% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIUMA_assessTDA.R
\name{predict_mapper_class}
\alias{predict_mapper_class}
\title{Predict Mapper Graph Geometry (lightweight)}
\usage{
predict_mapper_class(x, verbose = FALSE)
}
\arguments{
\item{x}{A \code{TDAobj} with \code{x@graph$igraph} set.}

\item{verbose}{Logical; print the chosen label. Default \code{FALSE}.}
}
\value{
The input \code{TDAobj} with \code{x@graph$predicted} set.
}
\description{
Infer a geometry label for \code{x@graph$igraph} using fast heuristics.
Writes only \code{x@graph$predicted$class} (one of
\code{c("SF","RGG","WS","ER","SBM","CM")}).

#' @details
Heuristics (hierarchical decision):
\itemize{
  \item \strong{SF (relaxed)}: rely on \code{checkScaleFreeModel(x)}. Declare
        scale-free if at least one of the following holds:
        \code{|corlogklogpk| >= 0.55}, \code{|corkpk| >= 0.70},
        \code{1.6 <= gamma <= 3.6}, or \code{Connectivity >= 0.40};
        alternatively accept SF if the product score
        \code{|corlogklogpk| * Connectivity >= 0.2}.
  \item \strong{WS}: small-world index \code{sigma > 1.2} with
        \code{C/C_ER >= 3} and \code{L/L_ER <= 1.2}.
  \item \strong{RGG}: very high clustering vs ER (\code{C/C_ER >= 5}),
        longer paths (\code{L/L_ER >= 1.3}), and positive degree
        assortativity (\code{r >= 0.10}).
  \item \strong{ER}: Poisson-like degree dispersion
        \code{VMR = var(k)/mean(k) ~ 1} (within 30\%),
        \code{|C - p| <= 0.05}, \code{|r| <= 0.05}, and
        \code{0.8 <= sigma <= 1.2}.
  \item \strong{SBM}: strong modular structure, \code{Q >= 0.40} with
        \code{>= 3} communities.
  \item \strong{CM}: heterogeneous degrees (\code{var(k)/mean(k) > 2}) with
        clustering close to ER (\code{|C - C_ER| <= 0.05}); otherwise use a
        sigma-based fallback (WS if \code{sigma > 1.2}, else ER).
}
The function sets only \code{x@graph$predicted}. It is intentionally
lightweight for fast computation.
}
\examples{
data(tda_test_data)
#tda_test_data <- predict_mapper_class(tda_test_data)

}
\author{
Carlo Leonardi, Mattia Chiesa
}
