% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIUMA_MapperCore.R
\name{mapperCore}
\alias{mapperCore}
\title{Implement the TDA Mapper algorithm on TDAobj}
\usage{
mapperCore(
  x,
  nBins = 15,
  overlap = 0.4,
  mClustNode = 2,
  remEmptyNode = TRUE,
  clustMeth = c("kmeans", "HR", "DBSCAN", "OPTICS"),
  HRMethod = c("average", "complete")
)
}
\arguments{
\item{x}{A TDAobj object, processed by the  \code{\link{dfToDistance}} and
\code{\link{dfToProjection}} functions.}

\item{nBins}{The number of bins (i.e. the resolution of the cover).
Default: 15.}

\item{overlap}{The overlap between bins (i.e.the gain of the cover).
Default: 0.4.}

\item{mClustNode}{The number of clusters in each overlapping bin. Default: 2}

\item{remEmptyNode}{A logical value to remove or not the empty nodes from
the resulting data.frame. Default: TRUE.}

\item{clustMeth}{The clustering algorithm."HR", "kmeans", "DBSCAN", and
"OPTICS" are allowed. Default: "kmeans".}

\item{HRMethod}{The name of the linkage criterion (when clustMeth="HR").
"average" and "complete" values are allowed. Default: "average".}
}
\value{
The starting TDAobj object, in which the result of mapper algorithm
(inferred nodes with their elements) has been added (slot: 'dfMapper')

A data.frame containing the clusters, with their elements,
 identified by TDA .
}
\description{
This is a comprehensive function permitting to perform the core
TDA Mapper algorithm with 2D lenses. It allow setting several types of
clustering methods. There is no restriction to \code{nBins}
and \code{mClustNode}, so the user can tune those for parameter search.
}
\examples{
# use example data:
data(vascEC_norm)
data(vascEC_meta)
df_TDA <- cbind(vascEC_meta, vascEC_norm)
df_TDA <- makeTDAobj(df_TDA,outcomes = c("stage","zone"))
df_TDA <- dfToDistance(df_TDA,'euclidean')
df_TDA <- dfToProjection(df_TDA, "PCA", nComp = 2)
df_TDA <- mapperCore(df_TDA,
          nBins = 5, overlap = 0.5,
          mClustNode = 2, clustMeth = "kmeans")
}
\seealso{
\code{\link{makeTDAobj}},
\code{\link{dfToDistance}},
\code{\link{dfToProjection}}
}
\author{
Mattia Chiesa, Laura Ballarini, Luca Piacentini, Carlo Leonardi
}
