% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-validateModel.R
\name{validateModel,PCOSP_or_RLS_or_RGA,SurvivalExperiment-method}
\alias{validateModel,PCOSP_or_RLS_or_RGA,SurvivalExperiment-method}
\title{Validate a PCOSP model with a single SurvivalExperiment object.}
\usage{
\S4method{validateModel}{PCOSP_or_RLS_or_RGA,SurvivalExperiment}(model, valData)
}
\arguments{
\item{model}{A \code{PCOSP} model which has been trained using \code{trainModel}.}

\item{valData}{A \code{SurvivalExperiment} to validate the model with.}
}
\value{
The \code{PCOSPmodel} with the validation statistics in the \code{validationStats}
slot and the validation data in the \code{validationData} slot.
}
\description{
Validate a PCOSP model with a single SurvivalExperiment object.
}
\examples{
data(sampleTrainedPCOSPmodel)
data(samplePCOSPpredList)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Validate model
validatedPCOSPmodel <- validateModel(sampleTrainedPCOSPmodel,
  valData=samplePCOSPpredList)

}
