% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-predictClasses.R
\name{predictClasses,SurvivalExperiment,PCOSP_or_RLS_or_RGA-method}
\alias{predictClasses,SurvivalExperiment,PCOSP_or_RLS_or_RGA-method}
\title{Predict Survival Prognosis Classes and Risk Scores for A \code{CohortList} Using
a \code{PCOSP}, \code{RLSModel} or \code{RGAModel} object.}
\usage{
\S4method{predictClasses}{SurvivalExperiment,PCOSP_or_RLS_or_RGA}(object, model, ...)
}
\arguments{
\item{object}{A \code{SurvivalExperiment} object to predict classes for.}

\item{model}{A trained \code{PCOSP} model to use for predicting classes.}

\item{...}{Fall through arguments to \code{BiocParallel::bplapply} for configuring
parallelization settings.}
}
\value{
A \code{SurvivalExperiment} with the predictions in its metadata and
a column in colData, \code{prob_good_survival}, which contains the proportion
of models which predicted good prognosis for each sample.
}
\description{
Predict Survival Prognosis Classes and Risk Scores for A \code{CohortList} Using
a \code{PCOSP}, \code{RLSModel} or \code{RGAModel} object.
}
\examples{
data(sampleTrainedPCOSPmodel)
data(samplePCSIsurvExp)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Make predictions
PCOSPpredSurvExp <- predictClasses(samplePCSIsurvExp,
  model=sampleTrainedPCOSPmodel)
head(colData(PCOSPpredSurvExp))

}
\seealso{
\code{\link[BiocParallel:bplapply]{BiocParallel::bplapply}}, \code{\link[switchBox:SWAP.KTSP.Classify]{switchBox::SWAP.KTSP.Classify}}
}
