% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVars.R
\name{getVars}
\alias{getVars}
\title{Return the explained variation for each principal component for an object of class 'pca'.}
\usage{
getVars(pcaobj, components = NULL)
}
\arguments{
\item{pcaobj}{Object of class 'pca' created by pca().}

\item{components}{Indices of the principal components whose explained
variances will be returned. If NULL, all values will be returned.}
}
\value{
A \code{\link{numeric}} object.
}
\description{
Return the explained variation for each principal component for an object of class 'pca'.
}
\details{
Return the explained variation for each principal component for an object of class 'pca'.
}
\examples{
  options(scipen=10)
  options(digits=6)

  col <- 20
  row <- 20000
  mat1 <- matrix(
    rexp(col*row, rate = 0.1),
    ncol = col)
  rownames(mat1) <- paste0('gene', 1:nrow(mat1))
  colnames(mat1) <- paste0('sample', 1:ncol(mat1))

  mat2 <- matrix(
    rexp(col*row, rate = 0.1),
    ncol = col)
  rownames(mat2) <- paste0('gene', 1:nrow(mat2))
  colnames(mat2) <- paste0('sample', (ncol(mat1)+1):(ncol(mat1)+ncol(mat2)))

  mat <- cbind(mat1, mat2)

  metadata <- data.frame(row.names = colnames(mat))
  metadata$Group <- rep(NA, ncol(mat))
  metadata$Group[seq(1,40,2)] <- 'A'
  metadata$Group[seq(2,40,2)] <- 'B'
  metadata$CRP <- sample.int(100, size=ncol(mat), replace=TRUE)
  metadata$ESR <- sample.int(100, size=ncol(mat), replace=TRUE)

  p <- pca(mat, metadata = metadata, removeVar = 0.1)

  getVars(p)

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
