% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigencorplot.R
\name{eigencorplot}
\alias{eigencorplot}
\title{Correlate principal components to continuous variable metadata and test significancies of these.}
\usage{
eigencorplot(
  pcaobj,
  components = getComponents(pcaobj, seq_len(10)),
  metavars,
  titleX = "",
  cexTitleX = 1,
  rotTitleX = 0,
  colTitleX = "black",
  fontTitleX = 2,
  titleY = "",
  cexTitleY = 1,
  rotTitleY = 0,
  colTitleY = "black",
  fontTitleY = 2,
  cexLabX = 1,
  rotLabX = 0,
  colLabX = "black",
  fontLabX = 2,
  cexLabY = 1,
  rotLabY = 0,
  colLabY = "black",
  fontLabY = 2,
  posLab = "bottomleft",
  col = c("blue4", "blue3", "blue2", "blue1", "white", "red1", "red2", "red3", "red4"),
  posColKey = "right",
  cexLabColKey = 1,
  cexCorval = 1,
  colCorval = "black",
  fontCorval = 1,
  scale = TRUE,
  main = "",
  cexMain = 2,
  rotMain = 0,
  colMain = "black",
  fontMain = 2,
  corFUN = "pearson",
  corUSE = "pairwise.complete.obs",
  corMultipleTestCorrection = "none",
  signifSymbols = c("***", "**", "*", ""),
  signifCutpoints = c(0, 0.001, 0.01, 0.05, 1),
  colFrame = "white",
  plotRsquared = FALSE,
  returnPlot = TRUE
)
}
\arguments{
\item{pcaobj}{Object of class 'pca' created by pca().}

\item{components}{The principal components to be included in the plot.}

\item{metavars}{A vector of column names in metadata representing continuos
variables.}

\item{titleX}{X-axis title.}

\item{cexTitleX}{X-axis title cex.}

\item{rotTitleX}{X-axis title rotation in degrees.}

\item{colTitleX}{X-axis title colour.}

\item{fontTitleX}{X-axis title font style. 1, plain; 2, bold; 3, italic; 4,
bold-italic.}

\item{titleY}{Y-axis title.}

\item{cexTitleY}{Y-axis title cex.}

\item{rotTitleY}{Y-axis title rotation in degrees.}

\item{colTitleY}{Y-axis title colour.}

\item{fontTitleY}{Y-axis title font style. 1, plain; 2, bold; 3, italic; 4,
bold-italic.}

\item{cexLabX}{X-axis labels cex.}

\item{rotLabX}{X-axis labels rotation in degrees.}

\item{colLabX}{X-axis labels colour.}

\item{fontLabX}{X-axis labels font style. 1, plain; 2, bold; 3, italic; 4,
bold-italic.}

\item{cexLabY}{Y-axis labels cex.}

\item{rotLabY}{Y-axis labels rotation in degrees.}

\item{colLabY}{Y-axis labels colour.}

\item{fontLabY}{Y-axis labels font style. 1, plain; 2, bold; 3, italic; 4,
bold-italic.}

\item{posLab}{Positioning of the X- and Y-axis labels. 'bottomleft', bottom
and left; 'topright', top and right; 'all', bottom / top and left /right;
'none', no labels.}

\item{col}{Colour shade gradient for RColorBrewer.}

\item{posColKey}{Position of colour key. 'bottom', 'left', 'top', 'right'.}

\item{cexLabColKey}{Colour key labels cex.}

\item{cexCorval}{Correlation values cex.}

\item{colCorval}{Correlation values colour.}

\item{fontCorval}{Correlation values font style. 1, plain; 2, bold; 3,
italic; 4, bold-italic.}

\item{scale}{Logical, indicating whether or not to scale the colour range
to max and min cor values.}

\item{main}{Plot title.}

\item{cexMain}{Plot title cex.}

\item{rotMain}{Plot title rotation in degrees.}

\item{colMain}{Plot title colour.}

\item{fontMain}{Plot title font style. 1, plain; 2, bold; 3, italic; 4,
bold-italic.}

\item{corFUN}{Correlation method: 'pearson', 'spearman', or 'kendall'.}

\item{corUSE}{Method for handling missing values (see documentation for cor
function via ?cor). 'everything', 'all.obs', 'complete.obs',
'na.or.complete', or 'pairwise.complete.obs'.}

\item{corMultipleTestCorrection}{Multiple testing p-value adjustment method.
Any method from stats::p.adjust() can be used. Activating this function means that
signifSymbols and signifCutpoints then relate to adjusted (not nominal) 
p-values.}

\item{signifSymbols}{Statistical significance symbols to display beside
correlation values.}

\item{signifCutpoints}{Cut-points for statistical significance.}

\item{colFrame}{Frame colour.}

\item{plotRsquared}{Logical, indicating whether or not to plot R-squared
values.}

\item{returnPlot}{Logical, indicating whether or not to return the plot
object.}
}
\value{
A \code{\link{lattice}} object.
}
\description{
Correlate principal components to continuous variable metadata and test significancies of these.
}
\details{
Correlate principal components to continuous variable metadata and test significancies of these.
}
\examples{
  options(scipen=10)
  options(digits=6)

  col <- 20
  row <- 20000
  mat1 <- matrix(
    rexp(col*row, rate = 0.1),
    ncol = col)
  rownames(mat1) <- paste0('gene', 1:nrow(mat1))
  colnames(mat1) <- paste0('sample', 1:ncol(mat1))

  mat2 <- matrix(
    rexp(col*row, rate = 0.1),
    ncol = col)
  rownames(mat2) <- paste0('gene', 1:nrow(mat2))
  colnames(mat2) <- paste0('sample', (ncol(mat1)+1):(ncol(mat1)+ncol(mat2)))

  mat <- cbind(mat1, mat2)

  metadata <- data.frame(row.names = colnames(mat))
  metadata$Group <- rep(NA, ncol(mat))
  metadata$Group[seq(1,40,2)] <- 'A'
  metadata$Group[seq(2,40,2)] <- 'B'
  metadata$CRP <- sample.int(100, size=ncol(mat), replace=TRUE)
  metadata$ESR <- sample.int(100, size=ncol(mat), replace=TRUE)

  p <- pca(mat, metadata = metadata, removeVar = 0.1)

  eigencorplot(p, components = getComponents(p, 1:10),
    metavars = c('ESR', 'CRP'))

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
