% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{hpDef}
\alias{hpDef}
\title{Description of HP terms (Example data)}
\format{A data frame with 10962 rows and 2 columns:
\describe{
\item{id}{HP term IDs}
\item{name}{HP term names}
}}
\source{
\url{http://compbio.charite.de/hudson/job/hpo/1529/artifact/hp/hp.obo}
}
\description{
HP terms basic information. Only descendants of
'Phenotypic abnormality' were taken into account.
}
\details{
These data are used to examplify the different functions of
the package.
More data are available in the MultiHumanPhenoDB package.
}
\examples{
## Prerequisite
data(geneByHp, hp_descendants, package="PCAN")
geneByHp <- unstack(geneByHp, entrez~hp)
ic <- computeHpIC(geneByHp, hp_descendants)

## Compute similarity between different couples of HP terms
data(hp_ancestors, hpDef, package="PCAN")
hp1 <- "HP:0000518"
hp2 <- "HP:0030084"
hp3 <- "HP:0002119"
hp4 <- "HP:0001305"
hpDef[which(hpDef$id \%in\% c(hp1, hp2)), 1:2]
calcHpSim(hp1, hp2, IC=ic, ancestors=hp_ancestors)
hpDef[which(hpDef$id \%in\% c(hp2, hp3)), 1:2]
calcHpSim(hp2, hp3, IC=ic, ancestors=hp_ancestors)
hpDef[which(hpDef$id \%in\% c(hp2, hp4)), 1:2]
calcHpSim(hp2, hp4, IC=ic, ancestors=hp_ancestors)
hpDef[which(hpDef$id \%in\% c(hp3, hp4)), 1:2]
calcHpSim(hp3, hp4, IC=ic, ancestors=hp_ancestors)
}

