% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SineFun.R
\name{SineFun}
\alias{SineFun}
\title{Apply sine model on one particular gene vs. other genes}
\usage{
SineFun(DataInSc,i)
}
\arguments{
\item{DataInSc}{a gene-by-sample (isoform-by-sample) matrix indicating the rescaled expression of two genes/isoforms.
all values should be bettwen [-1, 1].}

\item{i}{the gene (isoform) of interest. The function will apply the sine model on gene (isoform) i vs.
gene (isoform) j for all j > i. Gene (isoform) i (j) is defined as the gene (isoform )shown in the i (j) th
row. i should be smaller than the total number of genes (isoforms).}
}
\value{
Output is a list with two sublists, each shows the optimal phi's (shift) and epsilon's (value).
N-i entries will be included in each sublist (N is the total number of genes/isoforms). The kth entry
indicates results of gene (isoform) i vs. i+k.
}
\description{
Apply sine model on one particular gene vs. other genes
}
\examples{
aa <- sin(seq(0,1,.1))
bb <- sin(seq(0.5,1.5,.1))
cc <- sin(seq(0.9,1.9,.1))
SineFun(rbind(aa,bb,cc), 1)
}
\author{
Ning Leng
}

