% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/OscopeSine.R
\name{OscopeSine}
\alias{OscopeSine}
\title{Apply sine model on the full set of genes or isoforms}
\usage{
OscopeSine(DataInSc, parallel=FALSE, parallelParam=NULL)
}
\arguments{
\item{DataInSc}{a gene-by-sample (isoform-by-sample) matrix indicating the rescaled expression of two genes/isoforms.
all values should be bettwen [-1, 1].}

\item{parallel}{whether apply parallel computing. if it is TRUE, BiocParallel will be called.}

\item{parallelParam}{a SnowParam object to specify the clusters. If it is NULL, the default
will be set as SnowParam(workers = 5, type = "SOCK")
remains unchanged for over NCThre iterations.}
}
\value{
Output is a list with 4 sublists, each shows a N-by-N matrix, in which
N is the total number of genes (isoforms).
SimiMat: similarity matrix (sine scores); the sine scores are calculated
by -log10(epsilon^2).
DiffMat: dissimilarity matrix; shown are epsilon^2 for each gene pair.
ShiftMat: optimal phase shift estimate for each pair of genes.
}
\description{
Apply sine model on the full set of genes or isoforms
}
\examples{
aa <- sin(seq(0,1,.1))
bb <- sin(seq(0.5,1.5,.1))
cc <- sin(seq(0.9,1.9,.1))
OscopeSine(rbind(aa,bb,cc))
}
\author{
Ning Leng
}

