% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.R
\name{src_organism}
\alias{src_organism}
\alias{src_ucsc}
\alias{supportedOrganisms}
\alias{select_.tbl_organism}
\alias{src_tbls.src_organism}
\alias{tbl.src_organism}
\alias{orgPackageName,src_organism-method}
\alias{seqinfo,src_organism-method}
\title{Create a sqlite database from TxDb and corresponding Org packages}
\usage{
src_organism(txdb = NULL, dbpath = NULL, overwrite = FALSE)

src_ucsc(organism, genome = NULL, id = NULL, dbpath = NULL, verbose = TRUE)

supportedOrganisms()

\method{select_}{tbl_organism}(.data, ...)

\method{src_tbls}{src_organism}(x, ...)

\method{tbl}{src_organism}(src, from, ...)

\S4method{orgPackageName}{src_organism}(x)

\S4method{seqinfo}{src_organism}(x)
}
\arguments{
\item{txdb}{character(1) naming a \code{TxDb.*} package (e.g.,
\code{TxDb.Hsapiens.UCSC.hg38.knownGene}) or a \code{TxDb}
object instantiating the content of a \code{TxDb.*} pacakge.}

\item{dbpath}{character(1) path or BiocFileCache instance
representing the location where an Organism.dplyr SQLite
database will be accessed or created. If no path is specified,
the SQLite file is created in the default BiocFileCache()
location.}

\item{overwrite}{logical(1) overwrite an exisging `dbpath` contains
an Organism.dplyr SQLite databse different from the version
implied by `txdb`?}

\item{organism}{organism or common name}

\item{genome}{genome name}

\item{id}{choose from "knownGene", "ensGene" and "refGene"}

\item{verbose}{logical. Should R report extra information on progress?
Default is TRUE.}

\item{.data}{A tbl.}

\item{...}{Comma separated list of unquoted expressions. You can treat
variable names like they are positions. Use positive values to select
variables; use negative values to drop variables.}

\item{x}{A src_organism object}

\item{src}{An src_organism object}

\item{from}{character(1) name of temporary table in `src`.}
}
\value{
\code{src_organism()} and \code{src_ucsc()} returns a dplyr
    \code{src_dbi} instance representing the data tables.

A tibble of the requested table coming from the temporary
    database of the src_organism object.
}
\description{
The database provides a convenient way to map between gene, transcript,
and protein identifiers.

`select_.tbl_organism()` is DEPRECATED, please use
    `select()`.
}
\details{
\code{src_organism()} and \code{src_ucsc()} are meant to be building blocks
for \code{\link{src_organism}} objects, which provide an integrated
presentation of identifiers and genomic coordinates.

\code{src_organism()} creates a dplyr database integrating org.* and TxDb.*
information by given TxDb. And \code{src_ucsc()} creates the database by
given organism name, genome and/or id. Note that \code{src_ucsc()} requires
the \pkg{GenomeInfoDb} package to be installed.

supportedOrganisms() provides all supported organisms in this package with
corresponding OrgDb and TxDb.

The `tbl.src_organism()` parameter `.load_tbl_only` has been
removed. The function behaves as `.load_tbl_only = FALSE` (the
previous default); for `.load_tbl_only = TRUE`, use `tbl(src$con,
...)`.
}
\examples{
## create human sqlite database with TxDb.Hsapiens.UCSC.hg38.knownGene and
## corresponding org.Hs.eg.db
\dontrun{src <- src_organism("TxDb.Hsapiens.UCSC.hg38.knownGene")}
src <- src_organism(dbpath=hg38light())

## query using dplyr
inner_join(tbl(src, "id"), tbl(src, "id_go")) \%>\%
     filter(symbol == "ADA") \%>\%
     dplyr::select(entrez, ensembl, symbol, go, evidence, ontology)

## create human sqlite database using hg38 genome
\dontrun{human <- src_ucsc("human")}

## all supported organisms with corresponding OrgDb and TxDb
supportedOrganisms()

## Look at all available tables
src_tbls(src)

## Look at data in table "id"
tbl(src, "id")

## Look at fields of one table
colnames(tbl(src, "id"))

## name of org package of src_organism object
orgPackageName(src)

## seqinfo of src_organism object
seqinfo(src)

}
\seealso{
\code{\link{dplyr}} for details about using \code{dplyr} to
    manipulate data.

    \code{\link{transcripts_tbl}} for generic functions to extract
    genomic features from a \code{src_organism} object.

    \code{\link{select,src_organism-method}} for "select" interface
    on \code{src_organism} objects.
}
\author{
Yubo Cheng.
}
