% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor-methods.R
\name{Genomic-Extractors}
\alias{Genomic-Extractors}
\alias{cds}
\alias{cds_tbl}
\alias{cdsBy}
\alias{cdsBy_tbl}
\alias{exons}
\alias{exons_tbl}
\alias{exonsBy}
\alias{exonsBy_tbl}
\alias{fiveUTRsByTranscript}
\alias{fiveUTRsByTranscript_tbl}
\alias{genes}
\alias{genes_tbl}
\alias{intronsByTranscript}
\alias{intronsByTranscript_tbl}
\alias{promoters}
\alias{promoters_tbl}
\alias{threeUTRsByTranscript}
\alias{threeUTRsByTranscript_tbl}
\alias{transcripts}
\alias{transcripts_tbl}
\alias{transcriptsBy}
\alias{transcriptsBy_tbl}
\alias{promoters,src_organism-method}
\alias{intronsByTranscript,src_organism-method}
\title{Extract genomic features from src_organism objects}
\usage{
cds(x, ...)
 exons(x, ...)
 genes(x, ...)
 transcripts(x, ...)
 cds_tbl(x, filter=NULL, columns=NULL)
 exons_tbl(x, filter=NULL, columns=NULL)
 genes_tbl(x, filter=NULL, columns=NULL)
 transcripts_tbl(x, filter=NULL, columns=NULL)
 cdsBy(x, by=c("tx", "gene"), ...)
 exonsBy(x, by=c("tx", "gene"), ...)
 transcriptsBy(x, by=c("gene", "exon", "cds"), ...)
 cdsBy_tbl(x, by=c("tx", "gene"), filter=NULL, columns=NULL)
 exonsBy_tbl(x, by=c("tx", "gene"), filter=NULL, columns=NULL)
 transcriptsBy_tbl(x, by=c("gene", "exon", "cds"), filter=NULL, columns=NULL)
 promoters_tbl(x, upstream, downstream, filter=NULL, columns=NULL)
 intronsByTranscript_tbl(x, filter=NULL, columns=NULL)
 fiveUTRsByTranscript(x, ...)
 fiveUTRsByTranscript_tbl(x, filter=NULL, columns=NULL)
 threeUTRsByTranscript(x, ...)
 threeUTRsByTranscript_tbl(x, filter=NULL, columns=NULL)

\S4method{promoters}{src_organism}(x, upstream, downstream, filter = NULL, columns = NULL)

\S4method{intronsByTranscript}{src_organism}(x, filter = NULL, columns = NULL)
}
\arguments{
\item{x}{A \code{src_organism} object}

\item{upstream}{For \code{promoters()}: An integer(1) value indicating
the number of bases upstream from the transcription start site.}

\item{downstream}{For \code{promoters()}: An integer(1) value indicating
the number of bases downstream from the transcription start site.}

\item{filter}{Either NULL, \code{AnnotationFilter}, or
\code{AnnotationFilterList} to be used to restrict the output. Filters
consists of \code{AnnotationFilter}s and can be a \code{\link{GRanges}}
object using "GRangesFilter" (see examples).}

\item{columns}{A character vector indicating columns to be included in output
\code{GRanges} object or \code{tbl}.}

\item{by}{One of "gene", "exon", "cds" or "tx". Determines the grouping.}

\item{...}{Additional arguments to S4methods.  In this case, the same as
\code{filter}.}
}
\value{
functions with \code{_tbl} return a \code{\link[tibble]{tibble}}
    object, other methods return a \code{\link{GRanges}} or
    \code{\link{GRangesList}} object.
}
\description{
Generic functions to extract genomic features from an object. This
page documents the methods for \code{\link{src_organism}} objects
only.

These are the main functions for extracting transcript information
from a \code{\link{src_organism}} object, inherited from
\code{\link[GenomicFeatures]{transcripts}} in
\code{GenomicFeatures} package. Two versions of results are
provided: \code{\link[tibble]{tibble}} (\code{transcripts_tbl()})
and \code{\link{GRanges}} or \code{\link{GRangesList}}
(\code{transcripts()}).
}
\examples{
\dontrun{src <- src_ucsc("human")}
src <- src_organism(dbpath=hg38light())

## transcript coordinates with filter in tibble format
filters <- AnnotationFilter(~symbol == c("A1BG", "CDH2"))
transcripts_tbl(src, filters)

transcripts_tbl(src, AnnotationFilter(~symbol \%startsWith\% "SNORD"))
transcripts_tbl(src, AnnotationFilter(~go == "GO:0005615"))
transcripts_tbl(src, filter=AnnotationFilter(
     ~symbol \%startsWith\% "SNORD" & tx_start < 25070000))

## transcript coordinates with filter in granges format
filters <- GRangesFilter(GenomicRanges::GRanges("chr15:1-25070000"))
transcripts(src, filters)

## promoters
promoters(src, upstream=100, downstream=50,
          filter = SymbolFilter("ADA"))

## transcriptsBy
transcriptsBy(src, by = "exon", filter = SymbolFilter("ADA"))

## exonsBy
exonsBy(src, filter = SymbolFilter("ADA"))

## intronsByTranscript
intronsByTranscript(src, filter = SymbolFilter("ADA"))

}
\seealso{
\code{\link{src_organism}} for creating a \code{src_organism}
    object.
}
\author{
Yubo Cheng.
}
