% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{omnipath_cache_save}
\alias{omnipath_cache_save}
\title{Saves an R object to the cache}
\usage{
omnipath_cache_save(
  data,
  key = NULL,
  version = NULL,
  url = NULL,
  post = NULL,
  payload = NULL
)
}
\arguments{
\item{data}{An object}

\item{key}{Key of the cache item}

\item{version}{Version of the cache item. If does not exist a new version
item will be created}

\item{url}{URL of the downloaded resource}

\item{post}{HTTP POST parameters as a list}

\item{payload}{HTTP data payload}
}
\value{
Returns invisibly the data itself.

Invisibly returns the `data`.
}
\description{
Exports the object in RDS format, creates new cache record if necessary.
}
\examples{
mydata <- data.frame(a = c(1, 2, 3), b = c('a', 'b', 'c'))
omnipath_cache_save(mydata, url = 'some_dummy_address')
from_cache <- omnipath_cache_load(url = 'some_dummy_address')
from_cache
#   a b
# 1 1 a
# 2 2 b
# 3 3 c
attr(from_cache, 'origin')
# [1] "cache"

# basic example of saving and loading to and from the cache:
bioc_url <- 'https://bioconductor.org/'
bioc_html <- readChar(url(bioc_url), nchars = 99999)
omnipath_cache_save(bioc_html, url = bioc_url)
bioc_html <- omnipath_cache_load(url = bioc_url)

}
\seealso{
\code{\link{omnipath_cache_move_in}}
}
